#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/mds_file.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::toloka {
namespace table {
using namespace sql_chemistry;

struct MdsFile : Table<db::toloka::MdsFile> {
    static constexpr std::string_view name_{"toloka_mgr.mds_file"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    // not null?? FOREIGN KEY toloka_mgr.task
    static constexpr NumericColumn<TId> taskId{"task_id"sv, name_};
    static constexpr StringColumn mdsGroupId{"mds_group_id"sv, name_};
    static constexpr StringColumn mdsPath{"mds_path"sv, name_};

    static constexpr auto columns_() { return std::tie(id, taskId, mdsGroupId, mdsPath); }
};

} // namespace table

class MdsFileGateway : public sql_chemistry::Gateway<table::MdsFile> {
public:
    using Base = Gateway<table::MdsFile>;
    using Base::Base;
    using Base::Entities;
    using Tb = table::MdsFile;

    Entities loadByTaskIds(TIds ids) { return load(Tb::taskId.in(std::move(ids))); }

    size_t removeByTaskIds(TIds ids) { return remove(Tb::taskId.in(std::move(ids))); }
};

} // namespace maps::mrc::db::toloka
