#pragma once

#include "platform.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <string>
#include <vector>

namespace maps::mrc::db::toloka {


DECLARE_ENUM_IO(Platform);

enum class TaskType {
    ImageQualityClassification = 3,
    Approvement = 4,
    Taxonomy = 5,
    TrafficLightDetection = 6,
    HouseNumberDetection = 7,
    HouseNumberRecognition = 8,
    DetectionPairMatch = 9,
    DetectionMissingOnFrame = 10,
};

DECLARE_ENUM_IO(TaskType);

/// Represents items in toloka_mgr.task_type_info table which stores
/// task types supported by Toloka Manager.
/// The API does not allow creating new task types in database: new types
/// shall only be created by means of SQL migration.
class TaskTypeInfo {
public:

    TaskTypeInfo(Platform platform, TaskType taskType)
        : platform_(platform)
        , taskType_(static_cast<TId>(taskType))

    {}

    TaskType type() const { return static_cast<TaskType>(taskType_); }

    Platform platform() const { return platform_; }

    /// Toloka pool ID in which new task suites shall be created
    TId activePoolId() const { return activePoolId_; }

    /// Number of task suites currently contained in the active pool ID
    size_t activePoolSize() const { return activePoolSize_; }

    TaskTypeInfo& setActivePoolId(TId id) {
        activePoolId_ = id;
        return *this;
    }

    TaskTypeInfo& setActivePoolSize(size_t size) {
        activePoolSize_ = size;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<TaskTypeInfo>;
    TaskTypeInfo() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.platform_, t.taskType_, t.activePoolId_, t.activePoolSize_);
    }

    Platform platform_;
    TId taskType_{};
    TId activePoolId_{0};
    size_t activePoolSize_{0};

public:
    auto introspect() const { return introspect(*this); }
};

} // namespace maps::mrc::db::toloka
