#pragma once

#include "maps/libs/sql_chemistry/include/column.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_type_info.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway.h>


namespace maps::mrc::db::toloka {
namespace table {
using namespace sql_chemistry;

struct TaskTypeInfo : Table<db::toloka::TaskTypeInfo> {
    static constexpr std::string_view name_{"toloka_mgr.task_type_info"sv};

    // (type_id, platform) not null PRIMARY KEY FOREIGN KEY toloka_mgr.task_type_info
    static constexpr Int64PrimaryKey id{"type_id"sv, name_};
    static constexpr PrimaryKey<EnumColumn<Platform>> platform{"platform"sv, name_};
    static constexpr NumericColumn<TId> activePoolId{"active_pool_id"sv, name_}; // default 0
    static constexpr NumericColumn<size_t> activePoolSize{"active_pool_size"sv, name_}; // default 0

    static constexpr auto columns_() { return std::tie(platform, id, activePoolId, activePoolSize); }
};

} // namespace table

class TaskTypeInfoGateway : public sql_chemistry::Gateway<table::TaskTypeInfo> {
public:
    using Base = Gateway<table::TaskTypeInfo>;
    using Base::Base;
    using Base::EntitiesRef;

    TaskTypeInfo loadById(Platform platform, TaskType type)
    {
        return Base::loadOne(
            table::TaskTypeInfo::id == static_cast<int>(type) &&
            table::TaskTypeInfo::platform == platform);
    }

    std::optional<TaskTypeInfo> tryLoadById(Platform platform, TaskType type)
    {
        return Base::tryLoadOne(
            table::TaskTypeInfo::id == static_cast<int>(type) &&
            table::TaskTypeInfo::platform == platform);
    }
};

} // namespace maps::mrc::db::toloka
