#pragma once
#include "platform.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <string>
#include <vector>

namespace maps::mrc::db::toloka {

/// Represents items in toloka_mgr.toloka_task table. Each item stores data
/// of single task in Toloka created to solve affected Toloka Manager task.
/// This class is immutable: corresponding database record can only be
/// created or deleted but never modified.
class TolokaTask {
public:
    TolokaTask(Platform platform, TId taskSuiteId, int taskIndex, TId taskId, std::optional<std::string> tolokaId)
        : platform_(platform)
        , taskSuiteId_(taskSuiteId)
        , taskIndex_(taskIndex)
        , taskId_(taskId)
        , tolokaId_(std::move(tolokaId))
    {
    }

    Platform platform() const { return platform_; }

    TId taskSuiteId() const { return taskSuiteId_; }

    /// Index of the Toloka task within Toloka task suite
    int taskIndex() const { return taskIndex_; }

    /// Unique task identifier assigned by Toloka
    const std::optional<std::string>& tolokaId() const { return tolokaId_; }

    /// Affected Toloka Manager task Id
    TId taskId() const { return taskId_; }

    TolokaTask& setTolokaId(const std::string& tolokaId) {
        tolokaId_ = tolokaId;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<TolokaTask>;

    TolokaTask() = default;

    template<typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.platform_, t.taskSuiteId_, t.taskIndex_, t.taskId_, t.tolokaId_);
    }

    Platform platform_;
    TId taskSuiteId_{};
    int taskIndex_{};
    TId taskId_{};
    std::optional<std::string> tolokaId_;

public:
    auto introspect() const { return introspect(*this); }
};

using TolokaTasks = std::vector<TolokaTask>;

} // namespace maps::mrc::db::toloka
