#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/toloka_task.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::toloka {
namespace table {
using namespace sql_chemistry;

struct TolokaTask : Table<db::toloka::TolokaTask> {
    static constexpr std::string_view name_{"toloka_mgr.toloka_task"sv};

    static constexpr PrimaryKey<EnumColumn<Platform>> platform{"platform"sv, name_};
    static constexpr PrimaryKey<NumericColumn<TId>> taskSuiteId{"task_suite_id"sv, name_};
    static constexpr Int32PrimaryKey taskIndex{"task_index"sv, name_};
    // not null FOREIGN KEY
    static constexpr NumericColumn<TId> taskId{"task_id"sv, name_};
    static constexpr NullableStringColumn tolokaId{"toloka_id"sv, name_};

    static constexpr auto columns_() { return std::tie(platform, taskSuiteId, taskIndex, taskId, tolokaId); }
};

} // namespace table

class TolokaTaskGateway : public sql_chemistry::Gateway<table::TolokaTask> {
public:
    using Tb = table::TolokaTask;
    using Base = Gateway<Tb>;
    using Base::Base;
    using Base::Entities;

    Entities loadByTaskIds(TIds ids) { return load(Tb::taskId.in(std::move(ids))); }

    size_t removeByTaskIds(TIds ids) { return remove(Tb::taskId.in(std::move(ids))); }
};

} // namespace maps::mrc::db::toloka
