#pragma once

#include "platform.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <optional>
#include <string>
#include <vector>

namespace maps::mrc::db::toloka {

enum class TaskSuiteStatus {
    Unsolved,
    Solved,
};

/// Represents items in toloka_mgr.toloka_task_suite table. Each item stores
/// data of a single task suite in Toloka.
class TolokaTaskSuite {
public:
    TolokaTaskSuite(Platform platform)
        : platform_(platform)
    {}

    /// Unique task suite identifier in the database
    TId id() const { return id_; }

    Platform platform() const { return platform_; }

    /// Unique task suite identifier assigned by Toloka
    const std::string& tolokaId() const { return tolokaId_; }

    /// Toloka pool ID in which the task suite is created
    TId tolokaPoolId() const { return tolokaPoolId_; }

    int overlap() const { return overlap_; }

    chrono::TimePoint createdAt() const { return createdAt_; }

    OptionalTimePoint solvedAt() const { return solvedAt_; }

    TolokaTaskSuite& setTolokaId(std::string id) {
        tolokaId_ = std::move(id);
        return *this;
    }

    TolokaTaskSuite& setTolokaPoolId(TId id) {
        tolokaPoolId_ = id;
        return *this;
    }

    TolokaTaskSuite& setOverlap(int overlap) {
        overlap_ = overlap;
        return *this;
    }

    TolokaTaskSuite& setCreatedAt(chrono::TimePoint timePoint) {
        createdAt_ = timePoint;
        return *this;
    }

    TolokaTaskSuite& setSolvedAt(chrono::TimePoint timePoint) {
        solvedAt_ = timePoint;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<TolokaTaskSuite>;

    TolokaTaskSuite() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.platform_, t.tolokaId_, t.tolokaPoolId_, t.overlap_, t.createdAt_, t.solvedAt_);
    }

    TId id_{};
    Platform platform_;
    std::string tolokaId_{};
    TId tolokaPoolId_{};
    int overlap_{};
    chrono::TimePoint createdAt_{};
    OptionalTimePoint solvedAt_{};

public:
    auto introspect() const { return introspect(*this); }
};

using TolokaTaskSuites = std::vector<TolokaTaskSuite>;

} // namespace maps::mrc::db::toloka
