#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/toloka_task_suite.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::toloka {
namespace table {
using namespace sql_chemistry;

struct TolokaTaskSuite : Table<db::toloka::TolokaTaskSuite> {
    static constexpr std::string_view name_{"toloka_mgr.toloka_task_suite"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr EnumColumn<Platform> platform{"platform"sv, name_};
    static constexpr StringColumn tolokaId{"toloka_id"sv, name_};
    static constexpr NumericColumn<TId> tolokaPoolId{"toloka_pool_id"sv, name_};
    static constexpr Int32Column overlap{"overlap"sv, name_};
    static constexpr TimePointColumn createdAt{"created_at"sv, name_};
    static constexpr NullableTimePointColumn solvedAt{"solved_at"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, platform, tolokaId, tolokaPoolId, overlap, createdAt, solvedAt);
    }
};

} // namespace table

using TolokaTaskSuiteGateway = sql_chemistry::Gateway<table::TolokaTaskSuite>;

} // namespace maps::mrc::db::toloka
