#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/table_traits.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct TrackPoint : Table<db::TrackPoint> {
    static constexpr std::string_view name_{"signals.track_point"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn sourceId{"source_id"sv, name_};
    static constexpr MercatorColumn<geolib3::Point2> pos{"pos"sv, name_};
    static constexpr TimePointColumn timestamp{"date"sv, name_};
    static constexpr NullableDoubleColumn accuracy{"accuracy"sv, name_};
    static constexpr NullableDoubleColumn heading{"heading"sv, name_};
    static constexpr NullableDoubleColumn speed{"speed"sv, name_};
    static constexpr NullableBooleanColumn isAugmented{"is_augmented"sv, name_};
    static constexpr NullableNumericColumn<TId> assignmentId{"assignment_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, sourceId, pos, timestamp, accuracy, heading, speed,
            isAugmented, assignmentId);
    }
};

} // namespace table

using TrackPointGateway = sql_chemistry::Gateway<table::TrackPoint>;

TABLE_TRAITS(TrackPoint, table::TrackPoint);

} // namespace maps::mrc::db
