#pragma once

#include "common.h"
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/json/include/value.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <istream>
#include <ostream>
#include <unordered_map>
#include <vector>

namespace maps::mrc::db {

class TrafficLightHypothesis {
public:
    TrafficLightHypothesis(
        geolib3::Point2 mercatorPos,
        TId objectId,
        TId commitId,
        TId trafficLightId);

    TId id() const { return id_; }

    geolib3::Point2 mercatorPos() const { return mercatorPos_; }

    geolib3::Point2 geodeticPos() const {
        return geolib3::convertMercatorToGeodetic(mercatorPos());
    }

    TId objectId() const { return objectId_; }

    TId commitId() const { return commitId_; }

    TId trafficLightId() const { return trafficLightId_; }

    const json::Value& context() const { return context_; }

    TId feedbackTaskId() const { return feedbackTaskId_; }

    TrafficLightHypothesis& setContext(json::Value context);
    TrafficLightHypothesis& setFeedbackTaskId(TId id);

private:
    friend class sql_chemistry::GatewayAccess<TrafficLightHypothesis>;

    TrafficLightHypothesis() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.mercatorPos_, t.objectId_, t.commitId_,
            t.trafficLightId_, t.context_, t.feedbackTaskId_);
    }

    TId id_{};
    geolib3::Point2 mercatorPos_{};
    TId objectId_{};
    TId commitId_{};
    TId trafficLightId_{};
    json::Value context_{json::null};
    TId feedbackTaskId_{0};

public:
    auto introspect() const { return introspect(*this); }
};

using TrafficLightHypotheses = std::vector<TrafficLightHypothesis>;

} // namespace maps::mrc::db
