#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/traffic_light_hypothesis.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct TrafficLightHypothesis : Table<db::TrafficLightHypothesis> {
    static constexpr std::string_view name_{"traffic_light.hypotheses"sv};

    static constexpr BigSerialKey id{"hypothesis_id"sv, name_};
    static constexpr MercatorColumn<geolib3::Point2> position{"position"sv, name_};
    static constexpr NumericColumn<TId> objectId{"object_id"sv, name_};
    static constexpr NumericColumn<TId> commitId{"commit_id"sv, name_};
    static constexpr NumericColumn<TId> trafficLightId{"traffic_light_id"sv, name_};
    static constexpr JsonColumn context{"context"sv, name_};
    static constexpr NumericColumn<TId> feedbackTaskId{"feedback_task_id"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, position, objectId, commitId, trafficLightId, context, feedbackTaskId);
    }
};

} // namespace table

using TrafficLightHypothesisGateway = sql_chemistry::Gateway<table::TrafficLightHypothesis>;

} // namespace maps::mrc::db
