#pragma once

#include "assignment.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::ugc {
namespace table {
using namespace sql_chemistry;

struct Assignment : Table<db::ugc::Assignment> {
    static constexpr std::string_view name_{"ugc.assignment"sv};

    static constexpr BigSerialKey id{"assignment_id"sv, name_};
    static constexpr NumericColumn<TId> taskId{"task_id"sv, name_}; // FOREIGN KEY -> ugc.task
    static constexpr EnumColumn<AssignmentStatus> status{"status"sv, name_};
    static constexpr StringColumn assignedTo{"assigned_to"sv, name_};
    static constexpr TimePointColumn acquiredAt{"acquired_at"sv, name_};
    static constexpr NullableTimePointColumn submittedAt{"submitted_at"sv, name_};
    static constexpr NullableTimePointColumn evaluatedAt{"evaluated_at"sv, name_};

    static constexpr XminColumn xMin{name_};

    static constexpr auto columns_() {
        return std::tie(id, taskId, status, assignedTo, acquiredAt,
            submittedAt, evaluatedAt, xMin);
    }
};

} // namespace table

class AssignmentGateway : public sql_chemistry::Gateway<table::Assignment> {
public:
    using Tb = table::Assignment;
    using Base = Gateway<Tb>;
    using Base::Gateway;
    using Base::Entities;
    using Base::EntitiesRef;

    TIds loadIdsOrderByUpdateTimeDesc(size_t offset, size_t limit);

    void upsert(EntitiesRef) = delete;
};

} // namespace maps::mrc::db::ugc
