#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/geolib/include/point.h>

namespace maps::mrc::db::ugc {

enum class AssignmentObjectType {
    Barrier,
    Deadend,
    BadConditions,
    NoEntry,
};

DECLARE_ENUM_IO(AssignmentObjectType);

class AssignmentObject {
public:
    AssignmentObject(
        TId assignmentId,
        chrono::TimePoint created,
        const geolib3::Point2& geodeticPos,
        AssignmentObjectType objectType)
        : assignmentId_(assignmentId)
        , created_(created)
        , geodeticPos_(geodeticPos)
        , objectType_(objectType) {
    }

    TId objectId() const { return objectId_; }

    TId assignmentId() const { return assignmentId_; }

    chrono::TimePoint created() const { return created_; }

    geolib3::Point2 geodeticPos() const { return geodeticPos_; }

    AssignmentObjectType objectType() const { return objectType_; }

    const std::optional<std::string>& comment() const { return comment_; }

    AssignmentObject& setComment(std::string comment) {
        comment_ = std::move(comment);
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<AssignmentObject>;
    AssignmentObject() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.objectId_, t.assignmentId_, t.created_, t.geodeticPos_,
            t.objectType_, t.comment_);
    }

    TId objectId_{0u};
    TId assignmentId_{};
    chrono::TimePoint created_{};
    geolib3::Point2 geodeticPos_{};
    AssignmentObjectType objectType_{};
    std::optional<std::string> comment_{};

public:
    auto introspect() const { return introspect(*this); }
};

using AssignmentObjects = std::vector<AssignmentObject>;

} // namespace maps::mrc::db::ugc
