#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway_access.h>
#include <maps/libs/mds-client/include/yandex/maps/mds/mds.h>

#include <optional>

namespace maps::mrc::db::ugc {

class AssignmentRecordingReport {
public:
    AssignmentRecordingReport(TId assignmentId,
                              std::string sourceId,
                              mds::Key key)
        : assignmentId_(assignmentId)
        , sourceId_(std::move(sourceId))
        , mdsGroupId_(std::move(key.groupId))
        , mdsPath_(std::move(key.path)) {
    }

    AssignmentRecordingReport(TId assignmentId, std::string sourceId)
        : assignmentId_(assignmentId)
        , sourceId_(std::move(sourceId))
    {}

    TId id() const { return id_; }

    TId assignmentId() const { return assignmentId_; }

    bool hasSourceId() const { return sourceId_ != std::nullopt; }

    std::string sourceId() const {
        REQUIRE(hasSourceId(), "SourceId should not be empty");
        return *sourceId_;
    }

    mds::Key mdsKey() const { return {mdsGroupId_, mdsPath_}; }

    AssignmentRecordingReport& setMdsKey(mds::Key key) {
        mdsGroupId_ = std::move(key.groupId);
        mdsPath_ = std::move(key.path);
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<AssignmentRecordingReport>;
    AssignmentRecordingReport() = default;

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id_, t.assignmentId_, t.sourceId_,
                        t.mdsGroupId_, t.mdsPath_);
    }

    TId id_{};
    TId assignmentId_{};
    std::optional<std::string> sourceId_;
    std::string mdsGroupId_;
    std::string mdsPath_;

public:
    auto introspect() const { return introspect(*this); }
};

} // namespace maps::mrc::db::ugc
