#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_recording_report.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::ugc {
namespace table {
using namespace sql_chemistry;

struct AssignmentRecordingReport : Table<db::ugc::AssignmentRecordingReport> {
    static constexpr std::string_view name_{"ugc.assignment_recording_report"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    // not null FOREIGN KEY ugc.assignment
    static constexpr NumericColumn<TId> assignmentId{"assignment_id"sv, name_};
    static constexpr NullableStringColumn sourceId{"source_id"sv, name_};
    static constexpr StringColumn mdsGroupId{"mds_group_id"sv, name_};
    static constexpr StringColumn mdsPath{"mds_path"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, assignmentId, sourceId, mdsGroupId, mdsPath);
    }
};

} // namespace table

class AssignmentRecordingReportGateway
    : public sql_chemistry::Gateway<table::AssignmentRecordingReport> {
public:
    using Tb = table::AssignmentRecordingReport;
    using Base = Gateway<Tb>;
    using Base::Base;
    using Base::Entities;

    Entities loadByAssignmentId(TId assignmentId) { return load(Tb::assignmentId == assignmentId); }
};

} // namespace maps::mrc::db::ugc
