#pragma once

#include "tasks_group.h"

#include <maps/libs/sql_chemistry/include/columns/array.h>
#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db::ugc {
namespace table {
using namespace sql_chemistry;

struct TasksGroup : Table<db::ugc::TasksGroup> {
    static constexpr std::string_view name_{"ugc.tasks_group"sv};

    static constexpr BigSerialKey id{"tasks_group_id"sv, name_};
    static constexpr EnumColumn<TasksGroupStatus> status{"status"sv, name_};
    static constexpr StringColumn name{"name"sv, name_};
    static constexpr MercatorColumn<geolib3::MultiPolygon2> geom{"geom"sv, name_};
    static constexpr BooleanColumn useRouting{"routing"sv, name_};
    static constexpr NumericArrayColumn<int> fcs{"fcs"sv, name_};
    static constexpr BooleanColumn toll{"toll"sv, name_};
    static constexpr NumericColumn<uint32_t> recommendedTaskLength{"recommended_task_length_meters"sv, name_};
    static constexpr NullableFloatColumn minEdgeCoverageRatio{"min_edge_coverage_ratio"sv, name_};
    static constexpr BooleanColumn excludeDeadends{"exclude_deadends"sv, name_};
    static constexpr BooleanColumn ignorePrivateArea{"ignore_private_area"sv, name_};
    static constexpr Nullable<TimePointColumn> actualizedBefore{"actualized_before"sv, name_};
    static constexpr NullableUInt32Column totalLengthMeters{"total_length_meters"sv, name_};
    static constexpr NullableUInt32Column uniqueLengthMeters{"unique_length_meters"sv, name_};
    static constexpr NullableFloatColumn graphCoverageRatio{"graph_coverage_ratio"sv, name_};
    static constexpr Nullable<NumericArrayColumn<int16_t>> cameraDeviations{
        "camera_deviations"sv, name_};
    static constexpr Nullable<StringColumn> createdBy{"created_by"sv, name_};
    static constexpr Nullable<StringArrayColumn> allowedAssigneesLogins{"allowed_assignees_logins"sv, name_};

    static constexpr XminColumn xMin{name_};

    static constexpr auto columns_() {
        return std::tie(id, status, name, geom, useRouting, fcs, toll, recommendedTaskLength,
            minEdgeCoverageRatio, excludeDeadends, ignorePrivateArea,
            actualizedBefore, totalLengthMeters, uniqueLengthMeters, graphCoverageRatio,
            cameraDeviations, createdBy, allowedAssigneesLogins, xMin);
    }
};

struct TasksGroupEmail : Table<db::ugc::TasksGroupEmail> {
    static constexpr std::string_view name_{"ugc.tasks_group_email"sv};

    static constexpr NumericColumn<TId> tasksGroupId{"tasks_group_id"sv, name_};
    static constexpr StringColumn email{"email"sv, name_};

    static constexpr auto columns_() { return std::tie(tasksGroupId, email); }
};

} // namespace table

using TasksGroupGateway = sql_chemistry::Gateway<table::TasksGroup>;
using TasksGroupEmailGateway = sql_chemistry::Gateway<table::TasksGroupEmail>;

} // namespace maps::mrc::db::ugc
