#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway_access.h>

#include <optional>
#include <string>
#include <vector>

namespace maps::mrc::db {

class UgcAccount {
public:
    explicit UgcAccount(std::string userId) : UgcAccount()
    {
        setUserId(std::move(userId));
    }

    const std::string& userId() const { return userId_; }

    bool showAuthorship() const { return showAuthorship_.value_or(false); }

    UgcAccount& setUserId(std::string userId)
    {
        userId_ = move(userId);
        return *this;
    }

    UgcAccount& setShowAuthorship(bool showAuthorship)
    {
        showAuthorship_ = showAuthorship;
        return *this;
    }

private:
    friend class sql_chemistry::GatewayAccess<UgcAccount>;

    UgcAccount() = default;

    template <typename T>
    static auto introspect(T& t)
    {
        return std::tie(t.userId_, t.showAuthorship_);
    }

    std::string userId_;
    std::optional<bool> showAuthorship_;

public:
    auto introspect() const { return introspect(*this); }
};

using UgcAccounts = std::vector<UgcAccount>;

}  // namespace maps::mrc::db
