#pragma once

#include "common.h"

#include <maps/libs/sql_chemistry/include/gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc_account.h>

namespace maps::mrc::db {

namespace table {

using namespace sql_chemistry;

struct UgcAccount : Table<db::UgcAccount> {
    static constexpr std::string_view name_{"service.ugc_account"sv};

    static constexpr StringPrimaryKey userId{"user_id"sv, name_};
    static constexpr NullableBooleanColumn showAuthorship{"show_authorship"sv,
                                                          name_};

    static constexpr auto columns_()
    {
        return std::tie(userId, showAuthorship);
    }
};

}  // namespace table

using UgcAccountGateway = sql_chemistry::Gateway<table::UgcAccount>;

}  // namespace maps::mrc::db
