#pragma once

#include "video.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct Video : Table<db::Video> {
    static constexpr std::string_view name_{"signals.video"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr EnumColumn<Dataset> dataset{"dataset"sv, name_};
    static constexpr StringColumn sourceId{"source_id"sv, name_};
    static constexpr TimePointColumn startedAt{"started_at"sv, name_};
    static constexpr FloatColumn durationSeconds{"duration_seconds"sv, name_};
    static constexpr StringColumn mdsGroupId{"mds_group_id"sv, name_};
    static constexpr StringColumn mdsPath{"mds_path"sv, name_};
    static constexpr NullableInt64Column eventId{"event_id"sv, name_};
    static constexpr NullableInt64Column eventHash{"event_hash"sv, name_};

    static constexpr auto columns_() {
        return std::tie(
            id, dataset, sourceId, startedAt, durationSeconds,
            mdsGroupId, mdsPath, eventId, eventHash);
    }
};

struct FrameToVideo : Table<db::FrameToVideo> {
    static constexpr std::string_view name_{"signals.frame_to_video"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr Int64Column frameId{"frame_id"sv, name_};
    static constexpr Int64Column videoId{"video_id"sv, name_};
    static constexpr FloatColumn secondsFromStart{"seconds_from_start"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, frameId, videoId, secondsFromStart);
    }
};

} // namespace table

using VideoGateway = sql_chemistry::Gateway<table::Video>;
using FrameToVideoGateway = sql_chemistry::Gateway<table::FrameToVideo>;

} // namespace maps::mrc::db
