#pragma once

#include "walk_object.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::mrc::db {
namespace table {
using namespace sql_chemistry;

struct WalkObject : Table<db::WalkObject> {
    static constexpr std::string_view name_{"signals.walk_object"sv};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr StringColumn deviceId{"device_id"sv, name_};
    static constexpr TimePointColumn createdAt{"created_at"sv, name_};
    static constexpr NullableTimePointColumn publishedAt{"published_at"sv, name_};
    static constexpr EnumColumn<WalkFeedbackType> feedbackType{"feedback_type"sv, name_};
    static constexpr StringColumn comment{"comment"sv, name_};
    static constexpr NullableNumericColumn<TId> feedbackTaskId{"feedback_task_id"sv, name_};
    static constexpr EnumColumn<ObjectStatus> status{"status"sv, name_};
    static constexpr EnumColumn<Dataset> dataset{"dataset"sv, name_};
    static constexpr NullableStringColumn userId{"user_id"sv, name_};
    static constexpr GeneralGeometryColumn geometry{"geometry"sv, name_};
    static constexpr NullableStringColumn indoorLevelId{"indoor_level_id"sv, name_};
    static constexpr NullableEnumColumn<ObjectActionType> actionType{"action_type"sv, name_};
    static constexpr NullableStringColumn taskId{"task_id"sv, name_};
    static constexpr NullableStringColumn nmapsObjectId{"nmaps_object_id"sv, name_};
    static constexpr NumericColumn<TId> txnId{"txn_id"sv, name_};

    static constexpr auto columns_()
    {
        return std::tie(id,
                        deviceId,
                        createdAt,
                        publishedAt,
                        feedbackType,
                        comment,
                        feedbackTaskId,
                        status,
                        dataset,
                        userId,
                        geometry,
                        indoorLevelId,
                        actionType,
                        taskId,
                        nmapsObjectId,
                        txnId);
    }
};

} // namespace table

using WalkObjectGateway = TxnIdGatewayBase<table::WalkObject>;

} // namespace maps::mrc::db
