#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/dataset.h>

#include <algorithm>

namespace maps::mrc::db::tests {

TEST(feature_privacy_tests, select_stricter_privacy) {
    const std::vector<std::tuple<FeaturePrivacy, FeaturePrivacy, FeaturePrivacy>> testData{
        {FeaturePrivacy::Public, FeaturePrivacy::Public, FeaturePrivacy::Public},
        {FeaturePrivacy::Public, FeaturePrivacy::Restricted, FeaturePrivacy::Restricted},
        {FeaturePrivacy::Restricted, FeaturePrivacy::Public, FeaturePrivacy::Restricted},
        {FeaturePrivacy::Public, FeaturePrivacy::Secret, FeaturePrivacy::Secret},
        {FeaturePrivacy::Secret, FeaturePrivacy::Public, FeaturePrivacy::Secret},
        {FeaturePrivacy::Restricted, FeaturePrivacy::Restricted, FeaturePrivacy::Restricted},
        {FeaturePrivacy::Restricted, FeaturePrivacy::Secret, FeaturePrivacy::Secret},
        {FeaturePrivacy::Secret, FeaturePrivacy::Restricted, FeaturePrivacy::Secret},
        {FeaturePrivacy::Secret, FeaturePrivacy::Secret, FeaturePrivacy::Secret}
    };

    for (const auto& [lhs, rhs, result] : testData) {
        EXPECT_EQ(selectStricterPrivacy(lhs, rhs), result);
    }
}


TEST(dataset_tests, each_dataset_either_standalone_or_rides)
{
    const auto& standaloneDatasets = standalonePhotosDatasets();
    const auto& ridesDatasets = ridePhotosDatasets();

    size_t datasetSize = static_cast<std::underlying_type<Dataset>::type>(Dataset::End_);
    EXPECT_EQ(standaloneDatasets.size() + ridesDatasets.size(), datasetSize);

    for(auto value : standaloneDatasets) {
        EXPECT_TRUE(std::find(ridesDatasets.begin(), ridesDatasets.end(), value)
            == ridesDatasets.end()) << value << " belongs to both classes";

        EXPECT_TRUE(isStandalonePhotosDataset(value));
        EXPECT_FALSE(isRidesPhotosDataset(value));
    }

    for(auto value : ridesDatasets) {
        EXPECT_TRUE(std::find(standaloneDatasets.begin(), standaloneDatasets.end(), value)
            == standaloneDatasets.end()) << value << " belongs to both classes";

        EXPECT_FALSE(isStandalonePhotosDataset(value));
        EXPECT_TRUE(isRidesPhotosDataset(value));
    }
}

} // namespace maps::mrc::db::tests
