#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/eye/common.h>

namespace maps::mrc::db::eye::tests {

DeviceFixture::DeviceFixture()
{
    auto txn = txnHandle();

    devices = {
        Device(MrcDeviceAttrs{"M1"}),
        Device(MrcDeviceAttrs{"M2"}),
        Device(MrcDeviceAttrs{"M3"}),
    };

    DeviceGateway(*txn).insertx(devices);

    txn->commit();
}

FrameFixture::FrameFixture()
{
    auto txn = txnHandle();

    frames = {
        {
            devices[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            MrcUrlContext{1, "1", "1"},
            {1280, 720},
            chrono::parseSqlDateTime("2017-05-06 07:01:15+03")
        },
        {
            devices[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            MrcUrlContext{2, "2", "2"},
            {1280, 720},
            chrono::parseSqlDateTime("2017-05-06 07:05:15+03")
        },
        {
            devices[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            MrcUrlContext{3, "3", "3"},
            {1280, 720},
            chrono::parseSqlDateTime("2017-05-06 07:07:15+03")
        },
        {
            devices[1].id(),
            common::ImageOrientation(common::Rotation::CW_90),
            MrcUrlContext{4, "4", "4"},
            {1080, 1920},
            chrono::parseSqlDateTime("2016-04-02 05:57:11+03")
        },
        {
            devices[1].id(),
            common::ImageOrientation(common::Rotation::CW_90),
            MrcUrlContext{4, "5", "5"},
            {600, 480},
            chrono::parseSqlDateTime("2016-04-02 05:58:11+03")
        },
    };

    FrameGateway(*txn).insertx(frames);

    txn->commit();
}

DetectionFixture::DetectionFixture()
{
    auto txn = txnHandle();

    detectionGroups = {
        {
            frames[0].id(),
            DetectionType::Sign
        },
        {
            frames[1].id(),
            DetectionType::TrafficLight
        },
        {
            frames[2].id(),
            DetectionType::RoadMarking
        },
        {
            frames[3].id(),
            DetectionType::HouseNumber
        },
    };

    DetectionGroupGateway(*txn).insertx(detectionGroups);

    detections = {
        {
            detectionGroups[0].id(),
            DetectedSigns({
                DetectedSign {
                    common::ImageBox(100, 100, 200, 200),
                    traffic_signs::TrafficSign::ProhibitoryNoParking,
                    0.98,
                    false,
                    0.78
                }
            })
        },
        {
            detectionGroups[1].id(),
            DetectedTrafficLights({
                DetectedTrafficLight{
                    common::ImageBox(100, 100, 200, 200),
                    0.98
                }
            })
        },
        {
            detectionGroups[2].id(),
            DetectedRoadMarkings({
                DetectedRoadMarking{
                    common::ImageBox(100, 100, 200, 200),
                    traffic_signs::TrafficSign::RoadMarkingLaneDirectionF,
                    0.98,
                }
            })
        },
        {
            detectionGroups[3].id(),
            DetectedHouseNumbers({
                DetectedHouseNumber {
                    common::ImageBox(100, 100, 200, 200),
                    0.98,
                    "22"
                }
            })
        },
        {
            detectionGroups[0].id(),
            DetectedSigns({
                DetectedSign {
                    common::ImageBox(200, 200, 300, 300),
                    traffic_signs::TrafficSign::ProhibitoryNoParking,
                    0.97,
                    false,
                    0.79
                }
            })
        },

    };

    DetectionGateway(*txn).insertx(detections);

    txn->commit();
}


RecognitionTolokaFixture::RecognitionTolokaFixture()
{
    auto txn = txnHandle();

    const auto value = json(
        R"({
            "box": [[100, 100], [200, 200]],
            "type": "prohibitory_no_parking",
            "type_confidence": 0.98
        })"
    );

    recognitions = {
        {
            frames[0].id(),
            common::ImageOrientation(common::Rotation::CW_0),
            RecognitionType::DetectTrafficLight,
            RecognitionSource::Toloka,
            RECOGNITION_VERSION
        },
        {
            frames[1].id(),
            common::ImageOrientation(common::Rotation::CW_90),
            RecognitionType::DetectTrafficLight,
            RecognitionSource::Toloka,
            RECOGNITION_VERSION
        }
    };


    RecognitionGateway(*txn).insertx(recognitions);

    tasks = {
        toloka::Task(toloka::Platform::Toloka)
            .setType(toloka::TaskType::TrafficLightDetection)
            .setStatus(toloka::TaskStatus::New)
            .setInputValues("input-values-1")
            .setOverlap(3)
            .setCreatedAt(chrono::parseSqlDateTime("2017-01-01 00:00:00+03")),
        toloka::Task(toloka::Platform::Toloka)
            .setType(toloka::TaskType::TrafficLightDetection)
            .setStatus(toloka::TaskStatus::New)
            .setInputValues("input-values-2")
            .setOverlap(3)
            .setCreatedAt(chrono::parseSqlDateTime("2017-01-01 00:00:00+03"))
    };

    toloka::TaskGateway(*txn).insertx(tasks);

    txn->commit();
}

ObjectFixture::ObjectFixture()
{
    auto txn = txnHandle();

    const traffic_signs::TrafficSign signType = traffic_signs::TrafficSign::ProhibitoryNoParking;
    const bool temporary = true;
    const traffic_signs::TrafficSign roadMarkingType = traffic_signs::TrafficSign::RoadMarkingLaneDirectionF;
    const std::string number = "11";

    const TrafficLightAttrs trafficLightAttrs;
    const SignAttrs signAttrs{signType, temporary};
    const RoadMarkingAttrs roadMarkingAttrs{roadMarkingType};
    const HouseNumberAttrs houseNumberAttrs{number};

    objects = {
        {
            detections[0].id(),
            trafficLightAttrs
        },
        {
            detections[1].id(),
            signAttrs
        },
        {
            detections[2].id(),
            roadMarkingAttrs
        },
        {
            detections[3].id(),
            houseNumberAttrs
        },
    };

    ObjectGateway(*txn).insertx(objects);

    txn->commit();
}

HypothesisFixture::HypothesisFixture()
{
    auto txn = txnHandle();

    const wiki::revision::RevisionID revisionId{1, 2};
    const std::string number = "11";
    const AbsentTrafficLightAttrs absentTrafficLightAttrs{revisionId};
    const AbsentHouseNumberAttrs absentHouseNumberAttrs{number};
    const geolib3::Point2 mercatorPos1(100, 200);
    const geolib3::Point2 mercatorPos2(200, 300);

    hypotheses = {
        {
            mercatorPos1,
            absentTrafficLightAttrs
        },
        {
            mercatorPos2,
            absentHouseNumberAttrs
        },
    };

    HypothesisGateway(*txn).insertx(hypotheses);

    txn->commit();
}

} // namespace maps::mrc::db::eye::tests
