#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_gateway.h>

#include <maps/libs/json/include/value.h>

namespace maps::mrc::db::eye::tests {


constexpr int16_t RECOGNITION_VERSION = 1;

inline auto json(const std::string& value) { return json::Value::fromString(value); }

struct DeviceFixture: public db::tests::Fixture {
    DeviceFixture();
    Devices devices;
};

struct FrameFixture: public DeviceFixture {
    FrameFixture();
    Frames frames;
};

struct RecognitionTolokaFixture: public FrameFixture {
    RecognitionTolokaFixture();
    Recognitions recognitions;
    toloka::Tasks tasks;
};

struct DetectionFixture: public FrameFixture {
    DetectionFixture();
    DetectionGroups detectionGroups;
    Detections detections;
};

struct ObjectFixture: public DetectionFixture {
    ObjectFixture();
    Objects objects;
};

struct HypothesisFixture: public ObjectFixture {
    HypothesisFixture();
    Hypotheses hypotheses;
};

} // namespace maps::mrc::db::eye::tests
