#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/fixture.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>

#include <vector>

namespace maps::mrc::db::eye::tests {

namespace {

const common::ImageOrientation identical{};
const common::Size size {1280, 720};

const chrono::TimePoint sometime(std::chrono::seconds(12345));

MrcUrlContext makeUrlContext(TId featureId)
{
    const auto mdsId = std::to_string(featureId);

    return MrcUrlContext{featureId, mdsId, mdsId};
}

} // namespace

struct FeatureMatchingFixture: public db::tests::Fixture {
    FeatureMatchingFixture() {
        auto txn = txnHandle();

        features = {
            Feature{"one",
                    geolib3::Point2{0, 0},
                    geolib3::Heading{0},
                    "2016-04-01 05:57:00+03",
                    mds::Key{"1", "1"},
                    Dataset::Agents},
            Feature{"one",
                    geolib3::Point2{0, 0},
                    geolib3::Heading{0},
                    "2016-04-01 05:58:00+03",
                    mds::Key{"1", "2"},
                    Dataset::Agents},
            Feature{"two",
                    geolib3::Point2{0, 0},
                    geolib3::Heading{0},
                    "2016-04-01 05:59:00+03",
                    mds::Key{"1", "3"},
                    Dataset::Agents},
        };

        for (auto& feature : features) {
            feature.setSize(size)
                .setAutomaticShouldBePublished(true)
                .setIsPublished(true);
        }

        FeatureGateway(*txn).insert(features);

        devices = {
            Device(MrcDeviceAttrs{"M1"}),
            Device(MrcDeviceAttrs{"M2"}),
        };

        setTxnId(*txn, devices);
        DeviceGateway(*txn).insertx(devices);

        frames = {
            {devices[0].id(), identical, makeUrlContext(features[0].id()), size, sometime},
            {devices[0].id(), identical, makeUrlContext(features[1].id()), size, sometime},
            {devices[1].id(), identical, makeUrlContext(features[2].id()), size, sometime},
        };

        setTxnId(*txn, frames);
        FrameGateway(*txn).insertx(frames);

        txn->commit();
    }

    Features features;
    Devices devices;
    Frames frames;
};

TEST_F(FeatureMatchingFixture, eye_feature_device)
{
    std::vector<FeatureSourceToDevice> sourceToDevice {
        {features[0].sourceId(), devices[0].id()},
        {features[2].sourceId(), devices[1].id()},
    };

    auto txn = txnHandle();
    FeatureSourceToDeviceGateway(*txn).insert(sourceToDevice);

    txn->commit();

    { // check device + source pairs
        auto txn = txnHandle();

        const auto pairs = FeatureSourceToDeviceGateway(*txn).load(
            sql_chemistry::orderBy(table::FeatureSourceToDevice::sourceId)
        );

        EXPECT_EQ(pairs.size(), 2u);

        EXPECT_EQ(pairs[0].sourceId(), "one");
        EXPECT_EQ(pairs[0].deviceId(), devices[0].id());

        EXPECT_EQ(pairs[1].sourceId(), "two");
        EXPECT_EQ(pairs[1].deviceId(), devices[1].id());
    }
}

TEST_F(FeatureMatchingFixture, eye_feature_frame)
{
    std::vector<FeatureToFrame> featureToFrame {
        {features[0].id(), frames[0].id()},
        {features[1].id(), frames[1].id()},
        {features[2].id(), frames[2].id()},
    };

    auto txn = txnHandle();
    FeatureToFrameGateway(*txn).insert(featureToFrame);
    txn->commit();

    {   // create feature + frame pairs
        auto txn = txnHandle();

        const auto pairs = FeatureToFrameGateway(*txn).load(
            sql_chemistry::orderBy(table::FeatureToFrame::featureId)
        );

        EXPECT_EQ(pairs.size(), 3u);

        EXPECT_EQ(pairs[0].featureId(), features[0].id());
        EXPECT_EQ(pairs[0].frameId(), frames[0].id());

        EXPECT_EQ(pairs[1].featureId(), features[1].id());
        EXPECT_EQ(pairs[1].frameId(), frames[1].id());

        EXPECT_EQ(pairs[2].featureId(), features[2].id());
        EXPECT_EQ(pairs[2].frameId(), frames[2].id());
    }
}

} // namespace maps::mrc::db::tests
