#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/eye/common.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye_panorama_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/panorama_frame_gateway.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace maps::mrc::db::eye {
using introspection::operator==;
} // namespace maps::mrc::db

namespace maps::mrc::db::eye::tests {

struct PanoramaToFrameFixture: public FrameFixture {
    PanoramaToFrameFixture()
        : FrameFixture()
        , panoramas{
              {"OID_1" /* oid */,
               chrono::TimePoint::clock::now() /* date */,
               1 /* sessionId */,
               0 /* orderNum */,
               geolib3::Point2{1.0, 2.0} /* geodeticPos */,
               geolib3::Heading{90} /* vehicleCourse */,
               false /* deleted */},

              {"OID_2" /* oid */,
               chrono::TimePoint::clock::now() /* date */,
               1 /* sessionId */,
               1 /* orderNum */,
               geolib3::Point2{3.0, 4.0} /* geodeticPos */,
               geolib3::Heading{180} /* vehicleCourse */,
               true /* deleted */}}
    {
        auto txn = txnHandle();
        EyePanoramaGateway{*txn}.insertx(panoramas);
        txn->commit();
    }

    EyePanoramas panoramas;
};


TEST_F(PanoramaToFrameFixture, panorama_to_frame_test)
{
    PanoramaToFrames expected{
        {panoramas.at(0).oid(),
         frames.at(0).id(),
         panoramas.at(0).vehicleCourse() /* heading */,
         geolib3::Degrees{0} /* tilt */,
         geolib3::Degrees{70} /* horizontalFOV */,
         common::Size{1920, 1080}},

        {panoramas.at(1).oid(),
         frames.at(1).id(),
         panoramas.at(1).vehicleCourse() /* heading */,
         geolib3::Degrees{0} /* tilt */,
         geolib3::Degrees{70} /* horizontalFOV */,
         common::Size{1920, 1080}}};

    {
        auto txn = txnHandle();
        PanoramaToFrameGateway{*txn}.insert(expected);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        const auto loaded = PanoramaToFrameGateway{*txn}.load();
        EXPECT_EQ(loaded, expected);
    }
}

TEST_F(PanoramaToFrameFixture, panorama_session_to_device_test)
{
    PanoramaSessionToDevices expected{
        {
            panoramas.at(0).sessionId(),
            devices.at(0).id(),
            geolib3::Degrees{0},
        },
        {
            panoramas.at(0).sessionId(),
            devices.at(1).id(),
            geolib3::Degrees{180},
        }};

    {
        auto txn = txnHandle();
        PanoramaSessionToDeviceGateway{*txn}.insert(expected);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        const auto loaded = PanoramaSessionToDeviceGateway{*txn}.load();
        EXPECT_EQ(loaded, expected);
    }
}
} // namespace maps::mrc::db::tests
