#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/eye/common.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/common/include/exception.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_pair_match_gateway.h>
#include <yandex/maps/mrc/unittest/unittest_config.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task_type_info_gateway.h>

namespace maps::mrc::db::eye::tests {

TEST(eye_verified_detection_pair_match, verification_source)
{
    EXPECT_EQ(toString(VerificationSource::Toloka), "toloka");
    EXPECT_EQ(toString(VerificationSource::Yang), "yang");
    EXPECT_EQ(toString(VerificationSource::Nmaps), "nmaps");

    VerificationSource source;

    fromString("toloka", source);
    EXPECT_EQ(VerificationSource::Toloka, source);

    fromString("yang", source);
    EXPECT_EQ(VerificationSource::Yang, source);

    fromString("nmaps", source);
    EXPECT_EQ(VerificationSource::Nmaps, source);
}

TEST_F(DetectionFixture, make_verified_detection_pair_match)
{
    VerifiedDetectionPairMatch match(
        VerificationSource::Toloka,
        detections[0].id(), detections[1].id()
    );

    {
        auto txn = txnHandle();
        db::eye::VerifiedDetectionPairMatchGateway(*txn).insertx(match);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        VerifiedDetectionPairMatch loadedMatch
            = db::eye::VerifiedDetectionPairMatchGateway(*txn).loadById(match.id());

        EXPECT_EQ(loadedMatch.id(), match.id());
        EXPECT_EQ(loadedMatch.detectionId1(), detections[0].id());
        EXPECT_EQ(loadedMatch.detectionId2(), detections[1].id());
        EXPECT_EQ(loadedMatch.approved(), std::nullopt);
    }

    toloka::Tasks tasks = {
        toloka::Task(toloka::Platform::Toloka)
            .setType(toloka::TaskType::DetectionPairMatch)
            .setStatus(toloka::TaskStatus::New)
            .setInputValues("input-values-1")
            .setOverlap(3)
            .setCreatedAt(chrono::parseSqlDateTime("2017-01-01 00:00:00+03"))
    };

    {
        auto txn = txnHandle();
        db::toloka::TaskGateway(*txn).insertx(tasks);
        txn->commit();
    }

    VerifiedDetectionPairMatchToTolokaTask matchToToloka(match.id(), tasks[0].id());

    {
        auto txn = txnHandle();
        db::eye::VerifiedDetectionPairMatchToTolokaTaskGateway(*txn).insert(matchToToloka);
        txn->commit();
    }
}

TEST_F(DetectionFixture, unique_verified_detection_pair_match)
{
    VerifiedDetectionPairMatch match1(
        VerificationSource::Toloka,
        detections[0].id(), detections[1].id()
    );

    {
        auto txn = txnHandle();
        db::eye::VerifiedDetectionPairMatchGateway(*txn).insertx(match1);
        txn->commit();
    }

    VerifiedDetectionPairMatch match2(
        VerificationSource::Toloka,
        detections[0].id(), detections[1].id()
    );

    {
        auto txn = txnHandle();
        EXPECT_THROW(
            db::eye::VerifiedDetectionPairMatchGateway(*txn).insertx(match2),
            maps::sql_chemistry::UniqueViolationError
        );
    }
}

TEST_F(DetectionFixture, set_approved_verified_detection_pair_match)
{
    VerifiedDetectionPairMatch match(
        VerificationSource::Toloka,
        detections[0].id(), detections[1].id()
    );

    match.setApproved(true);

    {
        auto txn = txnHandle();
        db::eye::VerifiedDetectionPairMatchGateway(*txn).insertx(match);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        VerifiedDetectionPairMatch loadedMatch
            = db::eye::VerifiedDetectionPairMatchGateway(*txn).loadById(match.id());

        EXPECT_EQ(loadedMatch.id(), match.id());
        EXPECT_EQ(loadedMatch.detectionId1(), detections[0].id());
        EXPECT_EQ(loadedMatch.detectionId2(), detections[1].id());
        EXPECT_EQ(loadedMatch.approved(), true);
    }
}

} // namespace maps::mrc::db::eye::tests
