#include "fixture.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye_panorama_gateway.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace maps::mrc::db {
using introspection::operator==;
} // namespace maps::mrc::db

namespace maps::mrc::db::tests {

TEST_F(Fixture, test_eye_panoramas_smoke_test)
{
    EyePanoramas expected{
        {"OID_1" /* oid */,
         chrono::TimePoint::clock::now() /* date */,
         1 /* sessionId */,
         0 /* orderNum */,
         geolib3::Point2{1.0, 2.0} /* geodeticPos */,
         geolib3::Heading{90} /* vehicleCourse */,
         false /* deleted */},

        {"OID_2" /* oid */,
         chrono::TimePoint::clock::now() /* date */,
         1 /* sessionId */,
         1 /* orderNum */,
         geolib3::Point2{3.0, 4.0} /* geodeticPos */,
         geolib3::Heading{180} /* vehicleCourse */,
         true /* deleted */}};

    TId txnId{0};
    {
        auto txn = txnHandle();
        txnId = EyePanoramaGateway{*txn}.insertx(expected);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        const auto loaded = EyePanoramaGateway{*txn}.load();

        EXPECT_EQ(loaded, expected);
        EXPECT_EQ(loaded.at(0).txnId(), txnId);
        EXPECT_EQ(loaded.at(1).txnId(), txnId);
    }
}

} // namespace maps::mrc::db::tests
