#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/tests/playground.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/common/env.h>
#include <maps/libs/common/include/file_utils.h>
#include <yandex/maps/mrc/unittest/local_server.h>

namespace maps::mrc::db::tests {

class Fixture: public testing::Test
{
public:
    Fixture() {
        playground().postgres().truncateTables();
        insertData();
    }

    pgpool3::Pool& pgPool() { return playground().pool(); }

    pgpool3::TransactionHandle txnHandle() { return pgPool().masterWriteableTransaction(); }

    void insertData()
    {
        auto txn = txnHandle();;
        txn->exec(maps::common::readFileToString(SRC_("data.sql")));
        txn->commit();
    }
};

} // namespace maps::mrc::db::tests
