#include "fixture.h"
#include "gtest/gtest.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/nexar_frame_to_feature_gateway.h>


#include <library/cpp/testing/gtest/gtest.h>

namespace maps::mrc::db {
using introspection::operator==;
} // namespace maps::mrc::db

namespace maps::mrc::db::tests {
using namespace ::testing;


TEST_F(Fixture, nexar_frame_to_feature_create_load) {
    auto txn = txnHandle();

    auto feature = Feature(
            "source",
            geolib3::Point2{1.0, 1.0},
            geolib3::Heading{10},
            "2021-01-01 12:00:00+03",
            mds::Key{"key", "1.jpg"},
            Dataset::NexarDashcams);
    FeatureGateway(*txn).insert(feature);

    const std::string frameId = "frame1";

    NexarFrameToFeatureGateway gtw(*txn);
    NexarFrameToFeature frameToFeature(frameId, feature.id());
    gtw.insert(frameToFeature);

    auto loadedframeToFeature = gtw.load();
    ASSERT_EQ(loadedframeToFeature.size(), 1u);
    EXPECT_EQ(loadedframeToFeature[0], frameToFeature);
}

TEST_F(Fixture, nexar_frame_to_feature_check_unique_constaints)
{
    auto txn = txnHandle();
    auto features = Features{
        Feature(
            "source",
            geolib3::Point2{1.0, 1.0},
            geolib3::Heading{10},
            "2021-01-01 12:00:00+03",
            mds::Key{"key", "1.jpg"},
            Dataset::NexarDashcams),
        Feature(
            "source",
            geolib3::Point2{2.0, 2.0},
            geolib3::Heading{10},
            "2021-01-01 12:01:00+03",
            mds::Key{"key", "2.jpg"},
            Dataset::NexarDashcams),
            };
        FeatureGateway(*txn).insert(features);
        const std::string frameId = "frame1";

        NexarFrameToFeatureGateway gtw(*txn);
        NexarFrameToFeature frameToFeature(frameId, features[0].id());
        gtw.insert(frameToFeature);
        txn->commit();


        {
            auto txn = txnHandle();
            frameToFeature = NexarFrameToFeature(frameId, features[1].id());
            EXPECT_THROW(
                NexarFrameToFeatureGateway(*txn).insert(frameToFeature),
                maps::sql_chemistry::UniqueViolationError);
        }

        {
            auto txn = txnHandle();
            frameToFeature = NexarFrameToFeature(frameId + "tmp", features[0].id());
            EXPECT_THROW(
                NexarFrameToFeatureGateway(*txn).insert(frameToFeature),
                maps::sql_chemistry::UniqueViolationError);

        }
    }

} // namespace maps::mrc::db::tests
