#include "fixture.h"
#include "gtest/gtest.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/nexar_import_tile_update_info_gateway.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace maps::mrc::db {
using introspection::operator==;
} // namespace maps::mrc::db

namespace maps::mrc::db::tests {
using namespace ::testing;


TEST_F(Fixture, nexar_import_tile_test_create_load_update) {
    auto txn = txnHandle();

    NexarImportTileUpdateInfoGateway gtw(*txn);
    NexarImportTileUpdateInfo tileInfo(1, 2, 3, 4, 5);
    gtw.insert(tileInfo);

    auto loadedTiles = gtw.load();
    ASSERT_EQ(loadedTiles.size(), 1u);
    EXPECT_EQ(loadedTiles[0], tileInfo);

    const auto checkTime = chrono::parseSqlDateTime("2019-06-04 09:00:00+03");
    tileInfo.setCheckedAt(checkTime);
    tileInfo.setMedianPhotoAgeDays(32);

    gtw.update(tileInfo);

    loadedTiles = gtw.load();
    EXPECT_TRUE(loadedTiles[0].checkedAt().has_value());
    EXPECT_EQ(loadedTiles[0].checkedAt().value(), checkTime);
    EXPECT_EQ(loadedTiles[0], tileInfo);
}


TEST_F(Fixture, nexar_import_tile_test_primary_key)
{
    NexarImportTileUpdateInfo tileInfo(1, 2, 3, 4, 5);

    {
        auto txn = txnHandle();
        NexarImportTileUpdateInfoGateway(*txn).insert(tileInfo);
        txn->commit();
    }


    {
        auto txn = txnHandle();
        EXPECT_THROW(
            NexarImportTileUpdateInfoGateway(*txn).insert(tileInfo),
            maps::sql_chemistry::UniqueViolationError
        );
    }


    {
        auto txn = txnHandle();
        EXPECT_NO_THROW(
            NexarImportTileUpdateInfoGateway(*txn).upsert(tileInfo)
        );
        auto loadedTiles = NexarImportTileUpdateInfoGateway(*txn).load();
        EXPECT_EQ(loadedTiles.size(), 1u);
    }

}

} // namespace maps::mrc::db::tests
