#include "construct.h"
#include "fixture.h"

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/geolib/include/heading.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/object_in_photo_gateway.h>

namespace maps::mrc::db::tests {

using namespace testing;
using geolib3::Point2;
using geolib3::Heading;


TEST_F(Fixture, test_object_in_photo_gateway_smoke_test) {
    auto feature =
        Feature{
            "src1",
            Point2{43.999, 56.322},
            Heading{360.0},
            "2016-04-01 05:57:09+03",
            mds::Key{"4510", "1460732825/MRC_20160401_085709_1010624788.jpg"},
            Dataset::Agents}
            .setSize({6, 9})
            .setAutomaticShouldBePublished(true)
            .setIsPublished(true);

    {
        auto txn = txnHandle();
        FeatureGateway(*txn).insert(feature);
        txn->commit();
    }
    ObjectInPhoto objectFace{feature.id(), ObjectInPhotoType::Face, 0, 0, 10, 10, 0.9};
    ObjectInPhoto objectCarplate{feature.id(), ObjectInPhotoType::LicensePlate, 20, 20, 40, 40, 0.9};

    {
        auto txn = txnHandle();
        ObjectInPhotoGateway gtw(*txn);
        gtw.insert(objectFace);
        gtw.insert(objectCarplate);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        ObjectInPhotoGateway gtw(*txn);
        auto ids = gtw.loadIds();
        EXPECT_THAT(ids, UnorderedElementsAre(objectFace.id(), objectCarplate.id()));
        EXPECT_EQ(objectFace, gtw.loadById(objectFace.id()));
        EXPECT_EQ(objectCarplate, gtw.loadById(objectCarplate.id()));
    }
}

TEST_F(Fixture, test_object_in_photo_gateway_fail_to_create_dangling_feature_ref)
{
    ObjectInPhoto objectFace{1, ObjectInPhotoType::Face, 0, 0, 10, 10, 0.9};

    EXPECT_THROW(
        ObjectInPhotoGateway(*txnHandle()).insert(objectFace),
        pqxx::sql_error);
}

} // namespace maps::mrc::db::tests
