#include "fixture.h"

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/panorama_gateway.h>

namespace maps::mrc::db {
using introspection::operator==;
} // namespace maps::mrc::db

namespace maps::mrc::db::tests {

TEST_F(Fixture, test_panoramas_smoke_test)
{

    Panoramas expected{
        {
            "MDS_KEY_1",
            "MDS_SRC_KEY_1",
            chrono::TimePoint::clock::now(),
            1,
            0,
            geolib3::Point2{1.0, 2.0},
            90,
            180,
            0,
            1000,
            500,
            200000,
            100000,
            1
        },
        {
            "MDS_KEY_2",
            "MDS_SRC_KEY_2",
            chrono::TimePoint::clock::now(),
            1,
            1,
            geolib3::Point2{3.0, 4.0},
            90,
            90,
            15,
            2000,
            1000,
            400000,
            200000,
            2
        }
    };

    {
        auto txn = txnHandle();
        PanoramaGateway{*txn}.insert(expected);
        txn->commit();
    }

    auto txn = txnHandle();
    const auto loaded = PanoramaGateway{*txn}.load();

    EXPECT_EQ(loaded, expected);
}

} // namespace maps::mrc::db::tests
