#include "fixture.h"

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/introspection/include/stream_output.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/takeout_data_erasure_gateway.h>
#include <maps/libs/geolib/include/test_tools/comparison.h>

namespace maps::mrc::db {

using introspection::operator==;
using introspection::operator!=;
using introspection::operator<<;

}  // namespace maps::mrc::db

namespace maps::mrc::db::tests {

using namespace ::testing;
using Fixture = tests::Fixture;

    TEST_F(Fixture, takeout_data_erasure_gateway_test_takeout_data_erasure)
    {
        const auto TAKEOUT_REQUEST_ID =
            std::string{"86da91117e3ff8c16ec8546daa5323260a"};
        const auto USER_ID = std::string{"12345"};
        const auto REQUESTED_AT =
            chrono::parseSqlDateTime("2020-11-30 15:09:49+03");
        const auto FINISHED_AT =
            chrono::parseSqlDateTime("2020-11-30 15:17:23+03");
        const auto GRINDER_TASK_ID = std::string{"5f1813a816dad1580c97a08a"};

        TakeoutDataErasure example{TAKEOUT_REQUEST_ID, USER_ID, REQUESTED_AT};

        {
            auto txn = txnHandle();
            TakeoutDataErasureGateway gtw(*txn);
            gtw.insert(example);
            txn->commit();
        }

        {
            auto txn = txnHandle();
            TakeoutDataErasureGateway gtw(*txn);
            auto loaded = gtw.load();
            EXPECT_EQ(loaded.size(), 1u);
            EXPECT_EQ(example, loaded[0]);
        }

        example.setGrinderTaskId(GRINDER_TASK_ID).setFinishedAt(FINISHED_AT);

        {
            auto txn = txnHandle();
            TakeoutDataErasureGateway gtw(*txn);
            gtw.update(example);
            txn->commit();
        }

        {
            auto txn = txnHandle();
            TakeoutDataErasureGateway gtw(*txn);
            auto loaded = gtw.load();
            EXPECT_EQ(loaded.size(), 1u);
            EXPECT_EQ(example, loaded[0]);
        }
    }

}  // namespace maps::mrc::db::tests
