#include "fixture.h"

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/introspection/include/stream_output.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/takeout_ongoing_job_gateway.h>
#include <maps/libs/geolib/include/test_tools/comparison.h>

namespace maps::mrc::db {
using introspection::operator==;
using introspection::operator!=;
using introspection::operator<<;
} // namespace maps::mrc::db


namespace maps::mrc::db::tests {
using namespace ::testing;

using Fixture = tests::Fixture;

TEST_F(Fixture, test_takeout_ongoing_job) {
    const std::string JOB_ID_1 = "job_id_1";
    const std::string UID = "12345";
    const std::string GRINDER_TASK_ID = "5f1813a816dad1580c97a08a";
    TakeoutOngoingJob a{JOB_ID_1, UID, GRINDER_TASK_ID, chrono::parseSqlDateTime("2018-06-13 18:09:49.559+03")};

    {
        auto txn = txnHandle();
        TakeoutOngoingJobGateway gtw(*txn);
        gtw.insert(a);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        TakeoutOngoingJobGateway gtw(*txn);
        auto loaded = gtw.load();
        EXPECT_EQ(loaded.size(), 1u);
        EXPECT_EQ(a, loaded[0]);
    }

    {
        auto txn = txnHandle();
        TakeoutOngoingJobGateway gtw(*txn);
        gtw.remove(db::table::TakeoutOngoingJob::jobId == JOB_ID_1);
        txn->commit();
    }

    {
        auto txn = txnHandle();
        TakeoutOngoingJobGateway gtw(*txn);
        auto loaded = gtw.load();
        EXPECT_TRUE(loaded.empty());
    }
}

} // namespace maps::mrc::db::tests
