#include "construct.h"
#include "fixture.h"

#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc_account_gateway.h>
#include <yandex/maps/mrc/unittest/unittest_config.h>

namespace maps::mrc::db::tests {
using namespace ::testing;

namespace {

const auto USER_ID = std::string{"Joe"};
const bool SHOW_AUTHORSHIP = false;

}  // namespace

    TEST_F(Fixture, test_ugc_account)
    {
        {
            auto txn = txnHandle();
            auto ugcAccount = UgcAccount(USER_ID);
            UgcAccountGateway{*txn}.upsert(ugcAccount);
            txn->commit();
        }

        {
            auto txn = txnHandle();
            auto ugcAccount = UgcAccountGateway{*txn}.tryLoadOne(
                table::UgcAccount::userId == USER_ID);
            EXPECT_TRUE(ugcAccount);
            EXPECT_EQ(ugcAccount->userId(), USER_ID);
            ugcAccount->setShowAuthorship(SHOW_AUTHORSHIP);
            UgcAccountGateway{*txn}.upsert(*ugcAccount);
            txn->commit();
        }

        {
            auto txn = txnHandle();
            auto ugcAccount = UgcAccountGateway{*txn}.tryLoadOne(
                table::UgcAccount::userId == USER_ID);
            EXPECT_TRUE(ugcAccount);
            EXPECT_EQ(ugcAccount->userId(), USER_ID);
            EXPECT_TRUE(ugcAccount->showAuthorship() == SHOW_AUTHORSHIP);
        }
    }

}  // namespace maps::mrc::db::tests
