#include "geometry.h"
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/common.h>

namespace maps::mrc::fb {

namespace {

constexpr int sign(float val)
{
    return geolib3::sign(val, geolib3::EPS);
}

constexpr bool close(float lhs, float rhs)
{
    return sign(lhs - rhs) == 0;
}

}  // anonymous namespace

bool operator==(const PolylinePosition& lhs, const PolylinePosition& rhs)
{
    if (lhs.segmentIdx() == rhs.segmentIdx()) {
        return close(lhs.segmentRelPosition(), rhs.segmentRelPosition());
    }
    else if (lhs.segmentIdx() == rhs.segmentIdx() + 1) {
        return close(rhs.segmentRelPosition(), MAX_REL_POS) &&
               close(lhs.segmentRelPosition(), MIN_REL_POS);
    }
    else if (rhs.segmentIdx() == lhs.segmentIdx() + 1) {
        return close(lhs.segmentRelPosition(), MAX_REL_POS) &&
               close(rhs.segmentRelPosition(), MIN_REL_POS);
    }
    return false;
}

bool operator!=(const PolylinePosition& lhs, const PolylinePosition& rhs)
{
    return !(lhs == rhs);
}

bool operator<(const PolylinePosition& lhs, const PolylinePosition& rhs)
{
    if (lhs == rhs) {
        return false;
    }
    if (lhs.segmentIdx() == rhs.segmentIdx()) {
        return sign(lhs.segmentRelPosition() - rhs.segmentRelPosition()) < 0;
    }
    return lhs.segmentIdx() < rhs.segmentIdx();
}

bool operator>(const PolylinePosition& lhs, const PolylinePosition& rhs)
{
    return rhs < lhs;
}

bool operator<=(const PolylinePosition& lhs, const PolylinePosition& rhs)
{
    return !(rhs < lhs);
}

bool operator>=(const PolylinePosition& lhs, const PolylinePosition& rhs)
{
    return !(lhs < rhs);
}

geolib3::Polyline2 partition(const geolib3::Polyline2& polyline,
                             const PolylinePosition& begin,
                             const PolylinePosition& end)
{
    return geolib3::partition(polyline,
                              polyline.segmentAt(begin.segmentIdx())
                                  .pointByPosition(begin.segmentRelPosition()),
                              polyline.segmentAt(end.segmentIdx())
                                  .pointByPosition(end.segmentRelPosition()));
}

common::geometry::PolylinePosition convertToCommonPolylinePosition(
    const PolylinePosition& polylinePosition)
{
    return common::geometry::PolylinePosition(
        polylinePosition.segmentIdx(),
        polylinePosition.segmentRelPosition()
    );
}

common::geometry::SubPolyline convertToCommonSubpolyline(
    const CoveredSubPolyline& subpolyline)
{
    return common::geometry::SubPolyline{
        convertToCommonPolylinePosition(subpolyline.begin()),
        convertToCommonPolylinePosition(subpolyline.end())
    };
}

}  // namespace maps::mrc::fb
