#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/coverage_rtree_writer.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb_rtree/include/packer.h>

#include <boost/format.hpp>

namespace maps::mrc::fb {

void writeCoverageRtreeToDir(const road_graph::Graph& graph,
                             const TGraph& coverage,
                             const std::string& dir)
{
    REQUIRE(graph.version() == coverage.version,
            "inconsistent versions of graph ("
                << graph.version() << ") and coverage (" << coverage.version
                << ")");
    auto fcToLeafNodesMap = std::map<db::TFc, fb_rtree::LeafNodes>{};
    for (const auto& edge : coverage.edges) {
        auto edgeId = road_graph::EdgeId(edge.id);
        auto edgeData = graph.edgeData(edgeId);
        auto polyline = geolib3::Polyline2(edgeData.geometry());
        auto fc = db::TFc(edgeData.category());
        fcToLeafNodesMap[fc].push_back({edge.id, polyline.boundingBox()});
    }
    for (db::TFc fc = FC_MIN; fc <= FC_MAX; ++fc) {
        fb_rtree::packRtree(
            coverage.version,
            std::move(fcToLeafNodesMap[fc]),
            dir + "/" + (boost::format(COVERAGE_RTREE_FILE) % fc).str());
    }
}

}  // namespace maps::mrc::fb
