#include <maps/libs/succinct_buffers/include/writers.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/photo_to_edge_pairs_writer.h>

using namespace flatbuffers64;

namespace maps::mrc::fb {

void writePhotoToEdgePairsToFile(const std::string& graphVersion,
                                 const std::string& mrcVersion,
                                 TSchemaVersion schemaVersion,
                                 std::vector<PhotoToEdgePair>& photoToEdgePairs,
                                 const std::string& toFile)
{
    auto builder = FlatBufferBuilder{};
    auto graphVersion_ = builder.CreateString(graphVersion);
    auto mrcVersion_ = builder.CreateString(mrcVersion);
    auto photoToEdgePairs_ =
        builder.CreateVectorOfSortedStructs(&photoToEdgePairs);
    auto photoToEdgePairsBuilder = PhotoToEdgePairsBuilder{builder};
    photoToEdgePairsBuilder.add_graphVersion(graphVersion_);
    photoToEdgePairsBuilder.add_mrcVersion(mrcVersion_);
    photoToEdgePairsBuilder.add_schemaVersion(schemaVersion);
    photoToEdgePairsBuilder.add_photoToEdgePairs(photoToEdgePairs_);
    builder.Finish(photoToEdgePairsBuilder.Finish());
    maps::writeFlatBuffersToFile(builder, toFile);
}

}  // namespace maps::mrc::fb
