#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/traffic_sign_groups_reader.h>

using namespace flatbuffers64;

namespace maps::mrc::fb {

TrafficSignGroupsReader::TrafficSignGroupsReader(
    const std::string& fromDirectory,
    EMappingMode mappingMode
)
    : storage_{common::blobFromFile(fromDirectory + "/" + TRAFFIC_SIGN_GROUPS,
                                    mappingMode)}
    , trafficSignGroups_{GetRoot<TrafficSignGroups>(storage_.Data())}
{
}

std::string_view TrafficSignGroupsReader::version() const
{
    return decode(*trafficSignGroups_->version());
}

size_t TrafficSignGroupsReader::groupsNumber() const
{
    return trafficSignGroups_->groups()->size();
}

const TrafficSignGroup* TrafficSignGroupsReader::group(size_t offset) const
{
    REQUIRE(offset < groupsNumber(), "group offset is out of bounds");
    return trafficSignGroups_->groups()->Get(offset);
}

const TrafficSignGroup*
TrafficSignGroupsReader::groupById(db::TId groupId) const
{
    return trafficSignGroups_->groups()->LookupByKey(groupId);
}

}  // namespace maps::mrc::fb
