#include <maps/libs/succinct_buffers/include/writers.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/traffic_sign_groups_writer.h>

using namespace flatbuffers64;

namespace maps::mrc::fb {

void TrafficSignGroupsWriter::add(
    const db::TId& groupId,
    const db::TIds& objectIds,
    GroupOrientation orientation)
{
    auto ids = builder_.CreateVector(objectIds);

    auto groupBuilder = TrafficSignGroupBuilder(builder_);
    groupBuilder.add_groupId(groupId);
    groupBuilder.add_objectIds(ids);
    groupBuilder.add_orientation(orientation);
    offsets_.push_back(groupBuilder.Finish());
}

void TrafficSignGroupsWriter::dump(
    const std::string& version,
    const std::string& toDirectory)
{
    auto ver = builder_.CreateString(version);
    auto groups = builder_.CreateVectorOfSortedTables(&offsets_);
    auto groupsBuilder = TrafficSignGroupsBuilder(builder_);
    groupsBuilder.add_version(ver);
    groupsBuilder.add_groups(groups);
    builder_.Finish(groupsBuilder.Finish());
    maps::writeFlatBuffersToFile(builder_, toDirectory + "/" + TRAFFIC_SIGN_GROUPS);
}

}  // namespace maps::mrc::fb
