#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>

namespace maps::mrc::fb {

uint64_t toMilliseconds(chrono::TimePoint timePoint)
{
    return chrono::sinceEpoch<std::chrono::milliseconds>(timePoint);
}

chrono::TimePoint fromMilliseconds(uint64_t milliseconds)
{
    return chrono::TimePoint(std::chrono::milliseconds(milliseconds));
}

std::string_view decode(const flatbuffers64::String& str)
{
    return {str.c_str(), str.size()};
}

FeaturePrivacy encode(db::FeaturePrivacy privacy)
{
    switch (privacy) {
        case db::FeaturePrivacy::Public:
            return FeaturePrivacy_Public;
        case db::FeaturePrivacy::Restricted:
            return FeaturePrivacy_Restricted;
        case db::FeaturePrivacy::Secret:
            return FeaturePrivacy_Secret;
    }
}

db::FeaturePrivacy decode(FeaturePrivacy privacy)
{
    switch (privacy) {
        case FeaturePrivacy_Public:
            return db::FeaturePrivacy::Public;
        case FeaturePrivacy_Restricted:
            return db::FeaturePrivacy::Restricted;
        case FeaturePrivacy_Secret:
            return db::FeaturePrivacy::Secret;
    }
}

Dataset encode(db::Dataset dataset)
{
    switch (dataset) {
        case db::Dataset::Agents:
            return Dataset_Agents;
        case db::Dataset::Rides:
            return Dataset_Rides;
        case db::Dataset::Walks:
            return Dataset_Walks;
        case db::Dataset::Drive:
            return Dataset_Drive;
        case db::Dataset::Video:
            return Dataset_Video;
        case db::Dataset::PedestrianTask:
            return Dataset_PedestrianTask;
        case db::Dataset::BackofficeObject:
            return Dataset_BackofficeObject;
        case db::Dataset::BackofficePhoto:
            return Dataset_BackofficePhoto;
        case db::Dataset::Tehran:
            return Dataset_Tehran;
        case db::Dataset::AltayPedestrians:
            return Dataset_AltayPedestrians;
        case db::Dataset::YangPedestrians:
            return Dataset_YangPedestrians;
        case db::Dataset::NexarDashcams:
            return Dataset_NexarDashcams;
        case db::Dataset::TaxiSignalQ2:
            return Dataset_TaxiSignalQ2;
        case db::Dataset::TolokaPedestrians:
            return Dataset_TolokaPedestrians;
        case db::Dataset::End_:
            throw RuntimeError() << "unsupported dataset value " << dataset;
    }
}

db::Dataset decode(Dataset dataset)
{
    switch (dataset) {
        case Dataset_Agents:
            return db::Dataset::Agents;
        case Dataset_Rides:
            return db::Dataset::Rides;
        case Dataset_Walks:
            return db::Dataset::Walks;
        case Dataset_Drive:
            return db::Dataset::Drive;
        case Dataset_Video:
            return db::Dataset::Video;
        case Dataset_PedestrianTask:
            return db::Dataset::PedestrianTask;
        case Dataset_BackofficeObject:
            return db::Dataset::BackofficeObject;
        case Dataset_BackofficePhoto:
            return db::Dataset::BackofficePhoto;
        case Dataset_Tehran:
            return db::Dataset::Tehran;
        case Dataset_AltayPedestrians:
            return db::Dataset::AltayPedestrians;
        case Dataset_YangPedestrians:
            return db::Dataset::YangPedestrians;
        case Dataset_NexarDashcams:
            return db::Dataset::NexarDashcams;
        case Dataset_TaxiSignalQ2:
            return db::Dataset::TaxiSignalQ2;
        case Dataset_TolokaPedestrians:
            return db::Dataset::TolokaPedestrians;
    }
}

GraphType encode(db::GraphType type)
{
    switch (type) {
        case db::GraphType::Road:
            return GraphType_Road;
        case db::GraphType::Pedestrian:
            return GraphType_Pedestrian;
    }
}

db::GraphType decode(GraphType type)
{
    switch (type) {
        case GraphType_Road:
            return db::GraphType::Road;
        case GraphType_Pedestrian:
            return db::GraphType::Pedestrian;
    }
}

ObjectInPhotoType encode(db::ObjectInPhotoType type)
{
    switch (type) {
        case db::ObjectInPhotoType::Face:
            return ObjectInPhotoType_Face;
        case db::ObjectInPhotoType::LicensePlate:
            return ObjectInPhotoType_LicensePlate;
    }
}

db::ObjectInPhotoType decode(ObjectInPhotoType type)
{
    switch (type) {
        case ObjectInPhotoType_Face:
            return db::ObjectInPhotoType::Face;
        case ObjectInPhotoType_LicensePlate:
            return db::ObjectInPhotoType::LicensePlate;
    }
}

ObjectType encode(db::eye::ObjectType type)
{
    switch (type) {
        case db::eye::ObjectType::TrafficLight:
            return ObjectType_TrafficLight;
        case db::eye::ObjectType::Sign:
            return ObjectType_TrafficSign;
        case db::eye::ObjectType::RoadMarking:
            return ObjectType_RoadMarking;
        case db::eye::ObjectType::HouseNumber:
            return ObjectType_HouseNumber;
    }
}

db::eye::ObjectType decode(ObjectType type)
{
    switch (type) {
        case ObjectType_TrafficLight:
            return db::eye::ObjectType::TrafficLight;
        case ObjectType_TrafficSign:
            return db::eye::ObjectType::Sign;
        case ObjectType_RoadMarking:
            return db::eye::ObjectType::RoadMarking;
        case ObjectType_HouseNumber:
            return db::eye::ObjectType::HouseNumber;
    }
}

#define ADD_FB_ENUM_PREFIX(value) TrafficSignType_ ## value

#define CASE(value)                                          \
    case traffic_signs::TrafficSign :: value :               \
        return TrafficSignType :: ADD_FB_ENUM_PREFIX(value)

TrafficSignType encode(traffic_signs::TrafficSign trafficSignType)
{
    switch(trafficSignType) {
        CASE(Unknown);
        CASE(PriorityPriorityRoad);
        CASE(PriorityEofPriorityRoad);
        CASE(PriorityGiveWay);
        CASE(PriorityStop);
        CASE(PriorityStopGesture);
        CASE(PriorityOncomingVehicles);
        CASE(PriorityOverOncomingVehicles);
        CASE(ProhibitoryNoEntry);
        CASE(ProhibitoryNoVehicles);
        CASE(ProhibitoryNoHeavyGoodsVehicles);
        CASE(ProhibitoryNoRightTurn);
        CASE(ProhibitoryNoLeftTurn);
        CASE(ProhibitoryNoUturn);
        CASE(ProhibitoryMaxWeight);
        CASE(ProhibitoryMaxWeightPerAxle);
        CASE(ProhibitoryMaxHeight);
        CASE(ProhibitoryMaxWidth);

        CASE(ProhibitoryMaxSpeed);
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed5:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed10:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed15:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed20:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed25:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed30:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed35:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed40:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed45:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed50:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed55:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed60:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed70:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed80:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed90:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed100:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed110:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed120:
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed130:
            return TrafficSignType::TrafficSignType_ProhibitoryMaxSpeed;

        CASE(ProhibitoryEofMaxSpeed);
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed5:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed10:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed15:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed20:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed25:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed30:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed35:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed40:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed45:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed50:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed55:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed60:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed70:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed80:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed90:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed100:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed110:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed120:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed130:
            return TrafficSignType::TrafficSignType_ProhibitoryEofMaxSpeed;

        CASE(ProhibitoryNoParking);
        CASE(ProhibitoryNoParkingOrStopping);
        CASE(ProhibitoryNoOvertaking);
        CASE(ProhibitoryEofNoOvertaking);
        CASE(ProhibitoryNoOvertakingByHeavyVehicle);
        CASE(ProhibitoryEofNoOvertakingByHeavyVehicle);
        CASE(ProhibitoryNoMotorVehicles);
        CASE(ProhibitoryNoMotorcycles);
        CASE(ProhibitoryNoTractors);
        CASE(ProhibitoryNoTrailer);
        CASE(ProhibitoryNoHorseCarriages);
        CASE(ProhibitoryNoBicycles);
        CASE(ProhibitoryNoPedestrians);
        CASE(ProhibitoryMaxLength);
        CASE(ProhibitoryMinDistance);
        CASE(ProhibitoryCustoms);
        CASE(ProhibitoryDanger);
        CASE(ProhibitoryStop);
        CASE(ProhibitoryNoHornsOrMotorNoise);
        CASE(ProhibitoryNoParkingOnOddDaysOfTheMonth);
        CASE(ProhibitoryNoParkingOnEvenDaysOfTheMonth);
        CASE(ProhibitoryEofAll);
        CASE(ProhibitoryNoVehiclesCarryingDangerousGoods);
        CASE(ProhibitoryNoVehiclesCarryingExplosives);
        CASE(MandatoryProceedStraight);
        CASE(MandatoryProceedStraightOrTurnLeft);
        CASE(MandatoryProceedStraightOrTurnRight);
        CASE(MandatoryRoundabout);
        CASE(MandatoryTurnLeft);
        CASE(MandatoryTurnLeftAhead);
        CASE(MandatoryTurnRight);
        CASE(MandatoryTurnRightAhead);
        CASE(MandatoryTurnRightOrLeft);
        CASE(MandatoryDrivingDirectionR);
        CASE(MandatoryDrivingDirectionL);
        CASE(MandatoryDrivingDirectionRL);
        CASE(MandatoryCycleRoute);
        CASE(MandatoryEofCycleRoute);
        CASE(MandatoryPedestrianPath);
        CASE(MandatoryCyclistAndPedestriansCombinedPath);
        CASE(MandatoryEofCyclistAndPedestriansCombinedPath);
        CASE(MandatoryCyclistAndPedestriansSegregatedPath);
        CASE(MandatoryPedestrianAndCyclistsSegregatedPath);
        CASE(MandatoryEofCyclistAndPedestriansSegregatedPath);
        CASE(MandatoryEofPedestrianAndCyclistsSegregatedPath);
        CASE(MandatoryMinSpeed);
        CASE(MandatoryEofMinSpeed);
        CASE(MandatoryVehiclesCarryingExplosivesProceedStraight);
        CASE(MandatoryVehiclesCarryingExplosivesTurnRightAhead);
        CASE(MandatoryVehiclesCarryingExplosivesTurnLeftAhead);
        CASE(PrescriptionOneWayRoad);
        CASE(PrescriptionEofOneWayRoad);
        CASE(PrescriptionEntryToOneWayRoadOnTheRight);
        CASE(PrescriptionEntryToOneWayRoadOnTheLeft);
        CASE(PrescriptionRoadWithBusLane);
        CASE(PrescriptionEofRoadWithBusLane);
        CASE(PrescriptionBusLane);
        CASE(PrescriptionEofBusLane);
        CASE(PrescriptionLanesDirection);
        CASE(PrescriptionLaneDirectionFL);
        CASE(PrescriptionLaneDirectionFR);
        CASE(PrescriptionLaneDirectionF);
        CASE(PrescriptionLaneDirectionFl);
        CASE(PrescriptionLaneDirectionFr);
        CASE(PrescriptionLaneDirectionL);
        CASE(PrescriptionLaneDirectionRL);
        CASE(PrescriptionLaneDirectionR);
        CASE(PrescriptionLaneDirectionOther);
        CASE(PrescriptionStartNewLineRight);
        CASE(PrescriptionStartNewLineLeft);
        CASE(PrescriptionEndLineRight);
        CASE(PrescriptionEndLineLeft);
        CASE(PrescriptionLaneDirectionFFr);
        CASE(PrescriptionLaneDirectionFFl);
        CASE(PrescriptionLaneDirectionFrR);
        CASE(PrescriptionLaneDirectionFrFl);
        CASE(PrescriptionLaneDirectionB);
        CASE(PrescriptionLaneDirectionLFl);
        CASE(PrescriptionBuiltUpArea);
        CASE(PrescriptionBuiltUpAreaPictogram);
        CASE(PrescriptionEofBuiltUpArea);
        CASE(PrescriptionEofBuiltUpAreaPictogram);
        CASE(PrescriptionBuiltUpAreaWoRules);
        CASE(PrescriptionEofBuiltUpAreaWoRules);
        CASE(PrescriptionLimitedAccessRoad);
        CASE(PrescriptionEofLimitedAccessRoad);
        CASE(PrescriptionTwoWayTraffic);
        CASE(PrescriptionEofTwoWayTraffic);
        CASE(PrescriptionEntryToTwoWayTraffic);
        CASE(PrescriptionRoadWithCycleLane);
        CASE(PrescriptionEofRoadWithCycleLane);
        CASE(PrescriptionEntryToRoadWithBusLaneL);
        CASE(PrescriptionEntryToRoadWithBusLaneR);
        CASE(PrescriptionEntryToRoadWithCycleLaneL);
        CASE(PrescriptionEntryToRoadWithCycleLaneR);
        CASE(PrescriptionCycleLane);
        CASE(PrescriptionEofCycleLane);
        CASE(PrescriptionTwoWayLanesDirection);
        CASE(PrescriptionStoppingPlaceForBus);
        CASE(PrescriptionStoppingPlaceForTrams);
        CASE(PrescriptionStoppingPlaceForTaxi);
        CASE(PrescriptionPedestrianCrossing);
        CASE(PrescriptionRoadHump);
        CASE(PrescriptionLivingZone);
        CASE(PrescriptionEofLivingZone);
        CASE(InformationParking);
        CASE(InformationAdvisorySpeedLimit);
        CASE(InformationUTurnPlace);
        CASE(InformationUTurnDistance);
        CASE(InformationEmergencyStoppingLane);
        CASE(InformationPedestrianSubway);
        CASE(InformationFootbridge);
        CASE(InformationCulDeSacF);
        CASE(InformationCulDeSacR);
        CASE(InformationCulDeSacL);
        CASE(InformationDirectionCursor);
        CASE(InformationDirectionHeavyVehicleForward);
        CASE(InformationDirectionHeavyVehicleRight);
        CASE(InformationDirectionHeavyVehicleLeft);
        CASE(InformationStopLine);
        CASE(WarningRoundaboutAhead);
        CASE(WarningUnevenRoadAhead);
        CASE(WarningRoadNarrowsOnBoth);
        CASE(WarningRoadNarrowsOnRight);
        CASE(WarningRoadNarrowsOnLeft);
        CASE(WarningPedestrianCrossingAhead);
        CASE(WarningChildren);
        CASE(WarningCrossroadsMinorRoadRL);
        CASE(WarningCrossroadsMinorRoadR);
        CASE(WarningCrossroadsMinorRoadL);
        CASE(WarningCrossroadsMinorRoadFr);
        CASE(WarningCrossroadsMinorRoadFl);
        CASE(WarningCrossroadsMinorRoadBr);
        CASE(WarningCrossroadsMinorRoadBl);
        CASE(WarningLevelCrossingCountdown3R);
        CASE(WarningLevelCrossingCountdown2R);
        CASE(WarningLevelCrossingCountdown1R);
        CASE(WarningLevelCrossingCountdown3L);
        CASE(WarningLevelCrossingCountdown2L);
        CASE(WarningLevelCrossingCountdown1L);
        CASE(WarningTramCrossingAhead);
        CASE(WarningCrossroadsWithPriorityToTheRight);
        CASE(WarningTrafficSignalsAhead);
        CASE(WarningOpeningOrSwingBridge);
        CASE(WarningUnprotectedQuaysideOrRiverbank);
        CASE(WarningDangerousBendR);
        CASE(WarningDangerousBendL);
        CASE(WarningDangerousBendsR);
        CASE(WarningDangerousBendsL);
        CASE(WarningSteepDescent);
        CASE(WarningSteepAscent);
        CASE(WarningSlipperyRoadSurface);
        CASE(WarningUnevenRoad);
        CASE(WarningLooseChippings);
        CASE(WarningDangerousRoadside);
        CASE(WarningTwoWayTraffic);
        CASE(WarningCyclists);
        CASE(WarningRoadworksAhead);
        CASE(WarningDomesticAnimals);
        CASE(WarningWildAnimals);
        CASE(WarningFallingRocksOrDebris);
        CASE(WarningDangerousCrosswinds);
        CASE(WarningLowFlyingAircraft);
        CASE(WarningTunnelAhead);
        CASE(WarningTrafficJam);
        CASE(WarningOtherDangers);
        CASE(WarningTurningDirectionR);
        CASE(WarningTurningDirectionL);
        CASE(WarningTurningDirectionRL);
        CASE(InformationDistanceStopAhead);
        CASE(InformationDistanceObjectRight);
        CASE(InformationDistanceObjectLeft);
        CASE(InformationStartZone);
        CASE(InformationInZone);
        CASE(InformationHeavyVehicle);
        CASE(InformationLightVehicle);
        CASE(InformationHoliday);
        CASE(InformationWorkingDay);
        CASE(InformationHolidayTime);
        CASE(InformationWorkingDayTime);
        CASE(InformationPaidServices);
        CASE(InformationFirstAidStation);
        CASE(InformationHospital);
        CASE(InformationGasStation);
        CASE(InformationServiceStation);
        CASE(InformationCarWash);
        CASE(InformationPhone);
        CASE(InformationFood);
        CASE(InformationDrinkingWater);
        CASE(InformationHotel);
        CASE(InformationCamping);
        CASE(InformationRestingPlace);
        CASE(InformationTrafficPolice);
        CASE(InformationPolice);
        CASE(InformationCheckpointInternationalRoadTransport);
        CASE(InformationRadio);
        CASE(InformationRadioCommunicationWithEmergencyServices);
        CASE(InformationPoolOrBeach);
        CASE(InformationToilet);
        CASE(InformationEmergencyTelephone);
        CASE(InformationFireExtinguisher);
        CASE(InformationDistanceObject);
        CASE(InformationStartZoneHorizontal);
        CASE(InformationEofZone);
        CASE(InformationDirectionalR);
        CASE(InformationDirectionalL);
        CASE(InformationDirectionalRL);
        CASE(InformationTrailer);
        CASE(InformationBus);
        CASE(InformationTractor);
        CASE(InformationMotorcycle);
        CASE(InformationBicycle);
        CASE(InformationVehiclesCarryingDangerousGoods);
        CASE(InformationExceptHeavyVehicle);
        CASE(InformationExceptLightVehicle);
        CASE(InformationExceptBus);
        CASE(InformationExceptMotorcycle);
        CASE(InformationExceptBicycle);
        CASE(InformationExceptTaxi);
        CASE(InformationTime);
        CASE(InformationParkingMethod1);
        CASE(InformationParkingMethod2);
        CASE(InformationParkingMethod3);
        CASE(InformationParkingMethod4);
        CASE(InformationParkingMethod5);
        CASE(InformationParkingMethod6);
        CASE(InformationParkingMethod7);
        CASE(InformationParkingMethod8);
        CASE(InformationParkingMethod9);
        CASE(InformationParkingDeadstick);
        CASE(InformationParkingDurationLimit);
        CASE(InformationPlaceForCarsInspection);
        CASE(InformationLimitMaximumWeight);
        CASE(InformationDangerousRoadside);
        CASE(InformationCourseOfMainRoad);
        CASE(InformationLane);
        CASE(InformationBlindPedestrians);
        CASE(InformationWetCovering);
        CASE(InformationInvalids);
        CASE(InformationExceptInvalids);
        CASE(InformationObstacleL);
        CASE(InformationObstacleR);
        CASE(InformationObstacleF);
        CASE(InformationSpeedCamera);
        CASE(InformationTowTruck);
        CASE(WarningLevelCrossingWithBarrierOrGateAhead);
        CASE(WarningRailwayLevelCrossingWithoutBarrierOrGateAhead);
        CASE(PrescriptionMotorway);
        CASE(PrescriptionEofMotorway);
        default:
            return TrafficSignType_Unknown;
    }
}

#undef CASE
#define CASE(value)                                     \
    case TrafficSignType :: ADD_FB_ENUM_PREFIX(value):  \
        return traffic_signs::TrafficSign :: value 

traffic_signs::TrafficSign decode(TrafficSignType trafficSignType)
{
    switch(trafficSignType) {
        CASE(Unknown);
        CASE(PriorityPriorityRoad);
        CASE(PriorityEofPriorityRoad);
        CASE(PriorityGiveWay);
        CASE(PriorityStop);
        CASE(PriorityStopGesture);
        CASE(PriorityOncomingVehicles);
        CASE(PriorityOverOncomingVehicles);
        CASE(ProhibitoryNoEntry);
        CASE(ProhibitoryNoVehicles);
        CASE(ProhibitoryNoHeavyGoodsVehicles);
        CASE(ProhibitoryNoRightTurn);
        CASE(ProhibitoryNoLeftTurn);
        CASE(ProhibitoryNoUturn);
        CASE(ProhibitoryMaxWeight);
        CASE(ProhibitoryMaxWeightPerAxle);
        CASE(ProhibitoryMaxHeight);
        CASE(ProhibitoryMaxWidth);
        CASE(ProhibitoryMaxSpeed);
        CASE(ProhibitoryEofMaxSpeed);
        CASE(ProhibitoryNoParking);
        CASE(ProhibitoryNoParkingOrStopping);
        CASE(ProhibitoryNoOvertaking);
        CASE(ProhibitoryEofNoOvertaking);
        CASE(ProhibitoryNoOvertakingByHeavyVehicle);
        CASE(ProhibitoryEofNoOvertakingByHeavyVehicle);
        CASE(ProhibitoryNoMotorVehicles);
        CASE(ProhibitoryNoMotorcycles);
        CASE(ProhibitoryNoTractors);
        CASE(ProhibitoryNoTrailer);
        CASE(ProhibitoryNoHorseCarriages);
        CASE(ProhibitoryNoBicycles);
        CASE(ProhibitoryNoPedestrians);
        CASE(ProhibitoryMaxLength);
        CASE(ProhibitoryMinDistance);
        CASE(ProhibitoryCustoms);
        CASE(ProhibitoryDanger);
        CASE(ProhibitoryStop);
        CASE(ProhibitoryNoHornsOrMotorNoise);
        CASE(ProhibitoryNoParkingOnOddDaysOfTheMonth);
        CASE(ProhibitoryNoParkingOnEvenDaysOfTheMonth);
        CASE(ProhibitoryEofAll);
        CASE(ProhibitoryNoVehiclesCarryingDangerousGoods);
        CASE(ProhibitoryNoVehiclesCarryingExplosives);
        CASE(MandatoryProceedStraight);
        CASE(MandatoryProceedStraightOrTurnLeft);
        CASE(MandatoryProceedStraightOrTurnRight);
        CASE(MandatoryRoundabout);
        CASE(MandatoryTurnLeft);
        CASE(MandatoryTurnLeftAhead);
        CASE(MandatoryTurnRight);
        CASE(MandatoryTurnRightAhead);
        CASE(MandatoryTurnRightOrLeft);
        CASE(MandatoryDrivingDirectionR);
        CASE(MandatoryDrivingDirectionL);
        CASE(MandatoryDrivingDirectionRL);
        CASE(MandatoryCycleRoute);
        CASE(MandatoryEofCycleRoute);
        CASE(MandatoryPedestrianPath);
        CASE(MandatoryCyclistAndPedestriansCombinedPath);
        CASE(MandatoryEofCyclistAndPedestriansCombinedPath);
        CASE(MandatoryCyclistAndPedestriansSegregatedPath);
        CASE(MandatoryPedestrianAndCyclistsSegregatedPath);
        CASE(MandatoryEofCyclistAndPedestriansSegregatedPath);
        CASE(MandatoryEofPedestrianAndCyclistsSegregatedPath);
        CASE(MandatoryMinSpeed);
        CASE(MandatoryEofMinSpeed);
        CASE(MandatoryVehiclesCarryingExplosivesProceedStraight);
        CASE(MandatoryVehiclesCarryingExplosivesTurnRightAhead);
        CASE(MandatoryVehiclesCarryingExplosivesTurnLeftAhead);
        CASE(PrescriptionOneWayRoad);
        CASE(PrescriptionEofOneWayRoad);
        CASE(PrescriptionEntryToOneWayRoadOnTheRight);
        CASE(PrescriptionEntryToOneWayRoadOnTheLeft);
        CASE(PrescriptionRoadWithBusLane);
        CASE(PrescriptionEofRoadWithBusLane);
        CASE(PrescriptionBusLane);
        CASE(PrescriptionEofBusLane);
        CASE(PrescriptionLanesDirection);
        CASE(PrescriptionLaneDirectionFL);
        CASE(PrescriptionLaneDirectionFR);
        CASE(PrescriptionLaneDirectionF);
        CASE(PrescriptionLaneDirectionFl);
        CASE(PrescriptionLaneDirectionFr);
        CASE(PrescriptionLaneDirectionL);
        CASE(PrescriptionLaneDirectionRL);
        CASE(PrescriptionLaneDirectionR);
        CASE(PrescriptionLaneDirectionOther);
        CASE(PrescriptionStartNewLineRight);
        CASE(PrescriptionStartNewLineLeft);
        CASE(PrescriptionEndLineRight);
        CASE(PrescriptionEndLineLeft);
        CASE(PrescriptionLaneDirectionFFr);
        CASE(PrescriptionLaneDirectionFFl);
        CASE(PrescriptionLaneDirectionFrR);
        CASE(PrescriptionLaneDirectionFrFl);
        CASE(PrescriptionLaneDirectionB);
        CASE(PrescriptionLaneDirectionLFl);
        CASE(PrescriptionBuiltUpArea);
        CASE(PrescriptionBuiltUpAreaPictogram);
        CASE(PrescriptionEofBuiltUpArea);
        CASE(PrescriptionEofBuiltUpAreaPictogram);
        CASE(PrescriptionBuiltUpAreaWoRules);
        CASE(PrescriptionEofBuiltUpAreaWoRules);
        CASE(PrescriptionLimitedAccessRoad);
        CASE(PrescriptionEofLimitedAccessRoad);
        CASE(PrescriptionTwoWayTraffic);
        CASE(PrescriptionEofTwoWayTraffic);
        CASE(PrescriptionEntryToTwoWayTraffic);
        CASE(PrescriptionRoadWithCycleLane);
        CASE(PrescriptionEofRoadWithCycleLane);
        CASE(PrescriptionEntryToRoadWithBusLaneL);
        CASE(PrescriptionEntryToRoadWithBusLaneR);
        CASE(PrescriptionEntryToRoadWithCycleLaneL);
        CASE(PrescriptionEntryToRoadWithCycleLaneR);
        CASE(PrescriptionCycleLane);
        CASE(PrescriptionEofCycleLane);
        CASE(PrescriptionTwoWayLanesDirection);
        CASE(PrescriptionStoppingPlaceForBus);
        CASE(PrescriptionStoppingPlaceForTrams);
        CASE(PrescriptionStoppingPlaceForTaxi);
        CASE(PrescriptionPedestrianCrossing);
        CASE(PrescriptionRoadHump);
        CASE(PrescriptionLivingZone);
        CASE(PrescriptionEofLivingZone);
        CASE(InformationParking);
        CASE(InformationAdvisorySpeedLimit);
        CASE(InformationUTurnPlace);
        CASE(InformationUTurnDistance);
        CASE(InformationEmergencyStoppingLane);
        CASE(InformationPedestrianSubway);
        CASE(InformationFootbridge);
        CASE(InformationCulDeSacF);
        CASE(InformationCulDeSacR);
        CASE(InformationCulDeSacL);
        CASE(InformationDirectionCursor);
        CASE(InformationDirectionHeavyVehicleForward);
        CASE(InformationDirectionHeavyVehicleRight);
        CASE(InformationDirectionHeavyVehicleLeft);
        CASE(InformationStopLine);
        CASE(WarningRoundaboutAhead);
        CASE(WarningUnevenRoadAhead);
        CASE(WarningRoadNarrowsOnBoth);
        CASE(WarningRoadNarrowsOnRight);
        CASE(WarningRoadNarrowsOnLeft);
        CASE(WarningPedestrianCrossingAhead);
        CASE(WarningChildren);
        CASE(WarningCrossroadsMinorRoadRL);
        CASE(WarningCrossroadsMinorRoadR);
        CASE(WarningCrossroadsMinorRoadL);
        CASE(WarningCrossroadsMinorRoadFr);
        CASE(WarningCrossroadsMinorRoadFl);
        CASE(WarningCrossroadsMinorRoadBr);
        CASE(WarningCrossroadsMinorRoadBl);
        CASE(WarningLevelCrossingCountdown3R);
        CASE(WarningLevelCrossingCountdown2R);
        CASE(WarningLevelCrossingCountdown1R);
        CASE(WarningLevelCrossingCountdown3L);
        CASE(WarningLevelCrossingCountdown2L);
        CASE(WarningLevelCrossingCountdown1L);
        CASE(WarningTramCrossingAhead);
        CASE(WarningCrossroadsWithPriorityToTheRight);
        CASE(WarningTrafficSignalsAhead);
        CASE(WarningOpeningOrSwingBridge);
        CASE(WarningUnprotectedQuaysideOrRiverbank);
        CASE(WarningDangerousBendR);
        CASE(WarningDangerousBendL);
        CASE(WarningDangerousBendsR);
        CASE(WarningDangerousBendsL);
        CASE(WarningSteepDescent);
        CASE(WarningSteepAscent);
        CASE(WarningSlipperyRoadSurface);
        CASE(WarningUnevenRoad);
        CASE(WarningLooseChippings);
        CASE(WarningDangerousRoadside);
        CASE(WarningTwoWayTraffic);
        CASE(WarningCyclists);
        CASE(WarningRoadworksAhead);
        CASE(WarningDomesticAnimals);
        CASE(WarningWildAnimals);
        CASE(WarningFallingRocksOrDebris);
        CASE(WarningDangerousCrosswinds);
        CASE(WarningLowFlyingAircraft);
        CASE(WarningTunnelAhead);
        CASE(WarningTrafficJam);
        CASE(WarningOtherDangers);
        CASE(WarningTurningDirectionR);
        CASE(WarningTurningDirectionL);
        CASE(WarningTurningDirectionRL);
        CASE(InformationDistanceStopAhead);
        CASE(InformationDistanceObjectRight);
        CASE(InformationDistanceObjectLeft);
        CASE(InformationStartZone);
        CASE(InformationInZone);
        CASE(InformationHeavyVehicle);
        CASE(InformationLightVehicle);
        CASE(InformationHoliday);
        CASE(InformationWorkingDay);
        CASE(InformationHolidayTime);
        CASE(InformationWorkingDayTime);
        CASE(InformationPaidServices);
        CASE(InformationFirstAidStation);
        CASE(InformationHospital);
        CASE(InformationGasStation);
        CASE(InformationServiceStation);
        CASE(InformationCarWash);
        CASE(InformationPhone);
        CASE(InformationFood);
        CASE(InformationDrinkingWater);
        CASE(InformationHotel);
        CASE(InformationCamping);
        CASE(InformationRestingPlace);
        CASE(InformationTrafficPolice);
        CASE(InformationPolice);
        CASE(InformationCheckpointInternationalRoadTransport);
        CASE(InformationRadio);
        CASE(InformationRadioCommunicationWithEmergencyServices);
        CASE(InformationPoolOrBeach);
        CASE(InformationToilet);
        CASE(InformationEmergencyTelephone);
        CASE(InformationFireExtinguisher);
        CASE(InformationDistanceObject);
        CASE(InformationStartZoneHorizontal);
        CASE(InformationEofZone);
        CASE(InformationDirectionalR);
        CASE(InformationDirectionalL);
        CASE(InformationDirectionalRL);
        CASE(InformationTrailer);
        CASE(InformationBus);
        CASE(InformationTractor);
        CASE(InformationMotorcycle);
        CASE(InformationBicycle);
        CASE(InformationVehiclesCarryingDangerousGoods);
        CASE(InformationExceptHeavyVehicle);
        CASE(InformationExceptLightVehicle);
        CASE(InformationExceptBus);
        CASE(InformationExceptMotorcycle);
        CASE(InformationExceptBicycle);
        CASE(InformationExceptTaxi);
        CASE(InformationTime);
        CASE(InformationParkingMethod1);
        CASE(InformationParkingMethod2);
        CASE(InformationParkingMethod3);
        CASE(InformationParkingMethod4);
        CASE(InformationParkingMethod5);
        CASE(InformationParkingMethod6);
        CASE(InformationParkingMethod7);
        CASE(InformationParkingMethod8);
        CASE(InformationParkingMethod9);
        CASE(InformationParkingDeadstick);
        CASE(InformationParkingDurationLimit);
        CASE(InformationPlaceForCarsInspection);
        CASE(InformationLimitMaximumWeight);
        CASE(InformationDangerousRoadside);
        CASE(InformationCourseOfMainRoad);
        CASE(InformationLane);
        CASE(InformationBlindPedestrians);
        CASE(InformationWetCovering);
        CASE(InformationInvalids);
        CASE(InformationExceptInvalids);
        CASE(InformationObstacleL);
        CASE(InformationObstacleR);
        CASE(InformationObstacleF);
        CASE(InformationSpeedCamera);
        CASE(InformationTowTruck);
        CASE(WarningLevelCrossingWithBarrierOrGateAhead);
        CASE(WarningRailwayLevelCrossingWithoutBarrierOrGateAhead);
        CASE(PrescriptionMotorway);
        CASE(PrescriptionEofMotorway);
        default:
            return traffic_signs::TrafficSign::Unknown;
    }
}

#undef CASE
#undef ADD_FB_ENUM_PREFIX

std::optional<std::string> getSignText(traffic_signs::TrafficSign sign)
{
    switch (sign) {
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed5:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed5:
            return "5";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed10:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed10:
            return "10";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed15:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed15:
            return "15";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed20:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed20:
            return "20";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed25:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed25:
            return "25";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed30:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed30:
            return "30";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed35:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed35:
            return "35";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed40:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed40:
            return "40";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed45:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed45:
            return "45";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed50:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed50:
            return "50";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed55:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed55:
            return "55";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed60:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed60:
            return "60";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed70:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed70:
            return "70";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed80:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed80:
            return "80";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed90:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed90:
            return "90";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed100:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed100:
            return "100";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed110:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed110:
            return "110";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed120:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed120:
            return "120";
        case traffic_signs::TrafficSign::ProhibitoryMaxSpeed130:
        case traffic_signs::TrafficSign::ProhibitoryEofMaxSpeed130:
            return "130";
        default:
            return std::nullopt;
    }

}

}  // namespace maps::mrc::fb
