#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/dataset.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/object_in_photo.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_attrs.h>
#include <maps/wikimap/mapspro/services/mrc/libs/traffic_signs/include/yandex/maps/mrc/traffic_signs/signs.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/objects.fbs64.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/storage.fbs64.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/traffic_sign_type.fbs64.h>

namespace maps::mrc::fb {

const std::string COVERAGE_RTREE_FILE = "coverage_rtree_fc_%d.fb";
const std::string FEATURES_FILE = "features.fb";
const std::string OBJECTS_FILE = "objects.fb";
const std::string OBJECTS_RTREE_FILE = "objects_rtree.fb";
const std::string PHOTO_TIMELINES_FILE = "photo_timelines.fb";
const std::string RTREE_FILE = "rtree.fb";
const std::string TRAFFIC_SIGN_GROUPS = "traffic_sign_groups.fb";
const std::string WALK_OBJECT_PHOTOS_FILE = "walk_object_photos.fb";
const std::string WALK_OBJECTS_FILE = "walk_objects.fb";
const std::string WALK_OBJECTS_RTREE_FILE = "walk_objects_rtree.fb";

const std::string PARAM_MARKER = "%1%";

uint64_t toMilliseconds(chrono::TimePoint);
chrono::TimePoint fromMilliseconds(uint64_t);

template <class T>
geolib3::Point2 getPos(const T& val)
{
    return {val.posX(), val.posY()};
}

std::string_view decode(const flatbuffers64::String&);
FeaturePrivacy encode(db::FeaturePrivacy);
db::FeaturePrivacy decode(FeaturePrivacy);
Dataset encode(db::Dataset);
db::Dataset decode(Dataset);
GraphType encode(db::GraphType);
db::GraphType decode(GraphType);
ObjectInPhotoType encode(db::ObjectInPhotoType);
db::ObjectInPhotoType decode(ObjectInPhotoType);
ObjectType encode(db::eye::ObjectType);
db::eye::ObjectType decode(ObjectType);
TrafficSignType encode(traffic_signs::TrafficSign);
traffic_signs::TrafficSign decode(TrafficSignType);

std::optional<std::string> getSignText(traffic_signs::TrafficSign);

}  // namespace maps::mrc::fb
