#include <maps/libs/chrono/include/days.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/version.h>

namespace maps::mrc::fb {

/// version format: YY.MM.DD-milliseconds
std::string makeVersion(chrono::TimePoint timePoint)
{
    auto result = std::ostringstream{};
    auto sinceEpoch = timePoint.time_since_epoch();
    result << chrono::formatIntegralDateTime(timePoint, "%y.%m.%d");
    auto millisSinceDayStart =
        std::chrono::duration_cast<std::chrono::milliseconds>(sinceEpoch) -
        std::chrono::duration_cast<chrono::Days>(sinceEpoch);
    result << "-" << millisSinceDayStart.count();
    return result.str();
}

chrono::TimePoint parseVersion(const std::string& version)
{
    auto dashPos = version.find('-');
    REQUIRE(dashPos != std::string::npos,
            "invalid version format: " << version);
    auto date = version.substr(0, dashPos);
    auto milliseconds = version.substr(dashPos + 1);
    auto result = chrono::parseIntegralDateTime(date, "%y.%m.%d");
    result += std::chrono::milliseconds(std::stoll(milliseconds));
    return result;
}

}  // namespace maps::mrc::fb
