#include <maps/libs/succinct_buffers/include/writers.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/walk_objects_writer.h>

using namespace flatbuffers64;

namespace maps::mrc::fb {

void WalkObjectsWriter::add(const db::WalkObject& walkObject)
{
    REQUIRE(walkObject.geometryType() == geolib3::GeometryType::Point,
            "walk object is not point");

    auto pos = std::get<geolib3::Point2>(walkObject.geodeticGeometry());
    walkObjects_.push_back({static_cast<uint64_t>(walkObject.id()),
                            static_cast<float>(pos.x()),
                            static_cast<float>(pos.y())});
    leafNodes_.push_back(
        {.id = fb_rtree::Id(walkObject.id()), .bbox = pos.boundingBox()});
}

void WalkObjectsWriter::dump(const std::string& version,
                             const std::string& toDirectory)
{
    auto builder = FlatBufferBuilder{};
    auto ver = builder.CreateString(version);
    auto walkObjects = builder.CreateVectorOfSortedStructs(&walkObjects_);
    auto walkObjectsBuilder = WalkObjectsBuilder(builder);
    walkObjectsBuilder.add_version(ver);
    walkObjectsBuilder.add_walkObjects(walkObjects);
    builder.Finish(walkObjectsBuilder.Finish());
    maps::writeFlatBuffersToFile(builder,
                                 toDirectory + "/" + WALK_OBJECTS_FILE);
    fb_rtree::packRtree(
        version, leafNodes_, toDirectory + "/" + WALK_OBJECTS_RTREE_FILE);
}

}  // namespace maps::mrc::fb
