#include <contrib/libs/flatbuffers64/include/flatbuffers/flatbuffers.h>
#include <maps/libs/succinct_buffers/include/writers.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/write.h>

using namespace flatbuffers64;

namespace maps::mrc::fb {

namespace {

auto write(const TEdgeCoverage& src, FlatBufferBuilder& dest)
{
    auto coveredSubpolylines =
        dest.CreateVectorOfStructs(src.coveredSubpolylines);
    EdgeCoverageBuilder edgeCoverageBuilder(dest);
    edgeCoverageBuilder.add_coverageFraction(src.coverageFraction);
    edgeCoverageBuilder.add_actualizationDate(
        toMilliseconds(src.actualizationDate));
    edgeCoverageBuilder.add_coveredSubpolylines(coveredSubpolylines);
    edgeCoverageBuilder.add_cameraDeviation(
        db::toIntegral(src.cameraDeviation));
    edgeCoverageBuilder.add_privacy(encode(src.privacy));
    return edgeCoverageBuilder.Finish();
}

auto write(const std::vector<TEdgeCoverage>& src, FlatBufferBuilder& dest)
{
    std::vector<Offset<EdgeCoverage>> offsets;
    for (const auto& item : src) {
        offsets.push_back(write(item, dest));
    }
    return dest.CreateVector(offsets);
}

auto write(const TEdge& src, FlatBufferBuilder& dest)
{
    auto coverages = write(src.coverages, dest);
    EdgeBuilder edgeBuilder(dest);
    edgeBuilder.add_id(src.id);
    edgeBuilder.add_coverages(coverages);
    return edgeBuilder.Finish();
}

auto write(const std::vector<TEdge>& src, FlatBufferBuilder& dest)
{
    std::vector<Offset<Edge>> offsets;
    for (const auto& item : src) {
        offsets.push_back(write(item, dest));
    }
    return dest.CreateVectorOfSortedTables(&offsets);
}

}  // anonymous namespace

void writeToFile(const TGraph& graph, std::string_view path)
{
    FlatBufferBuilder builder;
    auto version = builder.CreateString(graph.version);
    auto edges = write(graph.edges, builder);
    auto mrcVersion = builder.CreateString(graph.mrcVersion);
    GraphBuilder graphBuilder(builder);
    graphBuilder.add_version(version);
    graphBuilder.add_edges(edges);
    graphBuilder.add_mrcVersion(mrcVersion);
    graphBuilder.add_schemaVersion(graph.schemaVersion);
    builder.Finish(graphBuilder.Finish());
    maps::writeFlatBuffersToFile(builder, path);
}

}  // namespace maps::mrc::fb
