#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/memory_map_option.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/geometry.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/storage.fbs64.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/version.h>
#include <maps/libs/geolib/include/polyline.h>

namespace maps::mrc::fb {

struct TEdgeCoverage {
    float coverageFraction;
    chrono::TimePoint actualizationDate;
    std::vector<CoveredSubPolyline> coveredSubpolylines;
    db::CameraDeviation cameraDeviation;
    db::FeaturePrivacy privacy;
};

struct TEdge {
    uint32_t id;
    std::vector<TEdgeCoverage> coverages;
};

struct TGraph {
    std::string version;
    std::vector<TEdge> edges;
    std::string mrcVersion;
    TSchemaVersion schemaVersion;
};

constexpr float MIN_REL_POS = 0.;
constexpr float MAX_REL_POS = 1.;

bool operator==(const PolylinePosition&, const PolylinePosition&);
bool operator!=(const PolylinePosition&, const PolylinePosition&);
bool operator>(const PolylinePosition&, const PolylinePosition&);
bool operator<(const PolylinePosition&, const PolylinePosition&);
bool operator>=(const PolylinePosition&, const PolylinePosition&);
bool operator<=(const PolylinePosition&, const PolylinePosition&);

geolib3::Polyline2 partition(const geolib3::Polyline2& polyline,
                             const PolylinePosition& begin,
                             const PolylinePosition& end);

struct TPhotoTime {
    chrono::TimePoint time;
    db::TId featureId;

    /// time is only key field
    friend bool operator<(const TPhotoTime& lhs, const TPhotoTime& rhs)
    {
        return lhs.time < rhs.time;
    }

    friend bool operator==(const TPhotoTime&, const TPhotoTime&) = default;
};

// don't edit - constants specify persistent file names
const db::TFc FC_MIN = 1;
const db::TFc FC_MAX = 10;

common::geometry::PolylinePosition convertToCommonPolylinePosition(
    const PolylinePosition& polylinePosition);

common::geometry::SubPolyline convertToCommonSubpolyline(
    const CoveredSubPolyline& subpolyline);

}  // namespace maps::mrc::fb
