#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/version.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb_rtree/include/packer.h>

#include <unordered_map>
#include <vector>

namespace maps::mrc::fb {

using TPhotoTimes = std::vector<TPhotoTime>;
using TPhotoTimelines = std::unordered_map<std::string, TPhotoTimes>;

class FeaturesWriter {
public:
    void add(const db::Feature&, const db::ObjectsInPhoto&);

    void dump(const std::string& version,
              db::TId lastTxnId,
              TSchemaVersion schemaVersion,
              const std::string& toDirectory);

private:
    flatbuffers64::FlatBufferBuilder builder_;
    std::vector<flatbuffers64::Offset<Feature>> offsets_;
    TPhotoTimelines photoTimelines_;
    std::vector<WalkObjectPhoto> walkObjectPhotos_;
    fb_rtree::LeafNodes leafNodes_;
    bool isDumped = false;

    void addFeature(
        const db::Feature&,
        std::optional<flatbuffers64::Offset<flatbuffers64::String>> sourceId,
        flatbuffers64::Offset<flatbuffers64::String> mdsPathPattern,
        std::optional<flatbuffers64::Offset<
            flatbuffers64::Vector<const ObjectInPhoto*>>>);

    void dumpFeatures(const std::string& version,
                      db::TId lastTxnId,
                      TSchemaVersion schemaVersion,
                      const std::string& toFile);
};

}  // namespace maps::mrc::fb
