#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/fb/impl/utility.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/version.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/objects.fbs64.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb_rtree/include/rtree.h>

#include <string>
#include <vector>

namespace maps::mrc::fb {

/**
 * Provides access to @ref Objects by object id or spatial index
 */
class ObjectsReader {
public:
    explicit ObjectsReader(const std::string& fromDirectory,
                           EMappingMode = EMappingMode::Standard);

    std::string_view version() const;

    size_t objectsNumber() const;

    /// @param offset in range [0, objectsNumber).
    const Object* object(size_t offset) const;

    const Object* objectById(db::TId) const;

    const fb_rtree::Rtree& rtree() const { return rtree_; };

    std::vector<const Object*>
    objectsInBbox(const geolib3::BoundingBox& geoBbox) const;

private:
    const TBlob objectsStorage_;
    const Objects* objects_;
    const fb_rtree::Rtree rtree_;
};

}  // namespace maps::mrc::fb
