#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/objects.fbs64.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/version.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb_rtree/include/packer.h>

#include <unordered_map>
#include <vector>

namespace maps::mrc::fb {

struct FrameWithOptDetection {
    db::eye::Frame frame;
    db::eye::FrameLocation frameLocation;
    std::optional<db::eye::Detection> detection;
};

class ObjectsWriter {
public:
    void add(
        const db::eye::Object&,
        const db::eye::ObjectLocation&,
        const std::vector<FrameWithOptDetection>&,
        const std::vector<traffic_signs::TrafficSign>& informationTables,
        const std::optional<db::TId>& groupId);

    void dump(
        const std::string& version,
        const std::string& toDirectory);

private:
    flatbuffers64::FlatBufferBuilder builder_;
    std::vector<flatbuffers64::Offset<Object>> offsets_;
    fb_rtree::LeafNodes leafNodes_;
};

}  // namespace maps::mrc::fb
