#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/memory_map_option.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/version.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/storage.fbs64.h>

#include <string>
#include <vector>

namespace maps::mrc::fb {

class PhotoToEdgePairsReader {
public:
    explicit PhotoToEdgePairsReader(const std::string& fromFile,
                                    EMappingMode = EMappingMode::Standard);

    std::string_view graphVersion() const;
    std::string_view mrcVersion() const;
    TSchemaVersion schemaVersion() const;
    size_t photoToEdgePairNumber() const;

    /// @param offset in range [0, photoToEdgePairNumber).
    const PhotoToEdgePair& photoToEdgePair(size_t offset) const;

    std::vector<PhotoToEdgePair> lookupByFeatureId(db::TId featureId) const;

private:
    const TBlob storage_;
    const PhotoToEdgePairs* photoToEdgePairs_;
};

}  // namespace maps::mrc::fb
