#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/common.h>

#include <optional>
#include <string>

namespace maps::mrc::fb {

class GraphReader {
public:
    explicit GraphReader(const std::string& path,
                         EMappingMode = EMappingMode::Standard);
    std::string_view version() const;
    size_t edgesNumber() const;
    TEdge edge(size_t) const;
    std::optional<TEdge> edgeById(uint32_t) const;
    std::string_view mrcVersion() const;
    TSchemaVersion schemaVersion() const;

private:
    const TBlob storage_;
    const Graph* graph_;
};

}  // namespace maps::mrc::fb
